/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.List;
import org.cyclonedx.model.formulation.common.AbstractType;
import org.cyclonedx.model.formulation.common.EnvVariableChoice;

public abstract class AbstractDataTypeSerializer<T extends AbstractType>
extends StdSerializer<T> {
    public AbstractDataTypeSerializer(Class<T> t) {
        super(t);
    }

    protected void parseEnvironmentVars(JsonGenerator jsonGenerator, List<EnvVariableChoice> vars) throws IOException {
        jsonGenerator.writeArrayFieldStart("environmentVars");
        for (EnvVariableChoice envVarChoice : vars) {
            if (envVarChoice.getEnvironmentVar() != null) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("environmentVar", (Object)envVarChoice.getEnvironmentVar());
                jsonGenerator.writeEndObject();
                continue;
            }
            if (envVarChoice.getValue() == null) continue;
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("value", (Object)envVarChoice.getValue());
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
    }

    protected void writeField(JsonGenerator jsonGenerator, String fieldName, Object fieldValue) throws IOException {
        if (fieldValue != null) {
            jsonGenerator.writeFieldName(fieldName);
            jsonGenerator.writeObject(fieldValue);
        }
    }
}

