/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.ec4j.core.EditorConfigLoader;
import org.ec4j.core.Resource;
import org.ec4j.core.model.EditorConfig;

public interface Cache {
    public EditorConfig get(Resource var1, EditorConfigLoader var2) throws IOException;

    public static class Caches {
        private static final Cache NO_CACHE = new Cache(){

            @Override
            public EditorConfig get(Resource editorConfigFile, EditorConfigLoader loader) throws IOException {
                return loader.load(editorConfigFile);
            }
        };

        public static Cache none() {
            return NO_CACHE;
        }

        public static Cache permanent() {
            return new PermanentCache();
        }

        private Caches() {
        }

        public static class PermanentCache
        implements Cache {
            private final Map<Resource, EditorConfig> entries = new HashMap<Resource, EditorConfig>();

            public void clear() {
                this.entries.clear();
            }

            @Override
            public EditorConfig get(Resource editorConfigFile, EditorConfigLoader loader) throws IOException {
                EditorConfig result = this.entries.get(editorConfigFile);
                if (result == null) {
                    result = loader.load(editorConfigFile);
                    this.entries.put(editorConfigFile, result);
                }
                return result;
            }
        }
    }
}

