/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.ec4j.core.model.Ec4jPath;

public class Glob {
    private static final int MAX_GLOB_LENGTH = 4096;
    private final PatternSyntaxException error;
    private final List<int[]> ranges;
    private final Pattern regex;
    private final String source;
    private final boolean matchLastSegmentOnly;
    static final Pattern ESCAPED_COMMENT_SIGNS = Pattern.compile("\\\\([#;])");

    public Glob(String source) {
        this.source = source;
        this.ranges = new ArrayList<int[]>();
        if (source.length() > 4096) {
            this.regex = null;
            this.error = new PatternSyntaxException("Glob length exceeds the maximal allowed length of 4096 characters", source, 4096);
            this.matchLastSegmentOnly = false;
        } else {
            source = ESCAPED_COMMENT_SIGNS.matcher(source).replaceAll("$1");
            int slashPos = source.indexOf(47);
            int doubleAsteriskPos = source.indexOf("**");
            if (slashPos >= 0) {
                source = slashPos == 0 ? source.substring(1) : source;
            }
            this.matchLastSegmentOnly = slashPos < 0 && doubleAsteriskPos < 0;
            StringBuilder regex = new StringBuilder(source.length());
            Glob.convertGlobToRegEx(source, this.ranges, regex);
            PatternSyntaxException err = null;
            Pattern pat = null;
            try {
                pat = Pattern.compile(regex.toString());
            }
            catch (PatternSyntaxException e) {
                err = e;
            }
            this.error = err;
            this.regex = pat;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Glob other = (Glob)obj;
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public PatternSyntaxException getError() {
        return this.error;
    }

    public String getSource() {
        return this.source;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    public boolean isValid() {
        return this.error == null;
    }

    public boolean match(Ec4jPath filePath) {
        if (!this.isValid()) {
            return false;
        }
        Matcher matcher = this.regex.matcher(this.matchLastSegmentOnly ? filePath.getLastSegment() : filePath.toString());
        if (matcher.matches()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                int[] range = this.ranges.get(i);
                String numberString = matcher.group(i + 1);
                if (numberString == null || numberString.startsWith("0")) {
                    return false;
                }
                int number = Integer.parseInt(numberString);
                if (number >= range[0] && number <= range[1]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.source;
    }

    static void convertGlobToRegEx(String globString, List<int[]> ranges, StringBuilder result) {
        int length = globString.length();
        int i = 0;
        int braceLevel = 0;
        boolean matchingBraces = Glob.matchingBraces(globString);
        boolean escaped = false;
        boolean inBrackets = false;
        while (i < length) {
            char current = globString.charAt(i);
            ++i;
            if ('*' == current) {
                if (i < length && globString.charAt(i) == '*') {
                    result.append(".*");
                    ++i;
                } else {
                    result.append("[^/]*");
                }
            } else if ('?' == current) {
                result.append(".");
            } else if ('[' == current) {
                boolean seenSlash;
                boolean bl = seenSlash = Glob.findChar('/', ']', globString, length, i) >= 0;
                if (seenSlash || escaped) {
                    result.append("\\[");
                } else if (i < length && "!^".indexOf(globString.charAt(i)) >= 0) {
                    ++i;
                    result.append("[^");
                } else {
                    result.append("[");
                }
                inBrackets = true;
            } else if (']' == current || '-' == current && inBrackets) {
                if (escaped) {
                    result.append("\\");
                }
                result.append(current);
                inBrackets = current != ']' || escaped;
            } else if ('{' == current) {
                int j = Glob.findChar(',', '}', globString, length, i);
                if (j < 0 && -j < length) {
                    String choice = globString.substring(i, -j);
                    int[] range = Glob.getNumericRange(choice);
                    if (range != null) {
                        result.append("(\\d+)");
                        ranges.add(range);
                    } else {
                        result.append("\\{");
                        Glob.convertGlobToRegEx(choice, ranges, result);
                        result.append("\\}");
                    }
                    i = -j + 1;
                } else if (matchingBraces) {
                    result.append("(?:");
                    ++braceLevel;
                } else {
                    result.append("\\{");
                }
            } else if (',' == current) {
                result.append(braceLevel > 0 && !escaped ? "|" : ",");
            } else if ('/' == current) {
                if (i < length && globString.charAt(i) == '*') {
                    if (i + 1 < length && globString.charAt(i + 1) == '*' && i + 2 < length && globString.charAt(i + 2) == '/') {
                        result.append("(?:/|/.*/)");
                        i += 3;
                    } else {
                        result.append(current);
                    }
                } else {
                    result.append(current);
                }
            } else if ('}' == current) {
                if (braceLevel > 0 && !escaped) {
                    result.append(")");
                    --braceLevel;
                } else {
                    result.append("}");
                }
            } else if ('\\' != current) {
                Glob.escapeToRegex(current, result);
            }
            if ('\\' == current) {
                if (escaped) {
                    result.append("\\\\");
                }
                escaped = !escaped;
                continue;
            }
            escaped = false;
        }
    }

    static boolean matchingBraces(String globString) {
        int i = 0;
        int len = globString.length();
        int openedCount = 0;
        block5: while (i < len) {
            switch (globString.charAt(i++)) {
                case '\\': {
                    ++i;
                    continue block5;
                }
                case '{': {
                    ++openedCount;
                    continue block5;
                }
                case '}': {
                    --openedCount;
                    continue block5;
                }
            }
        }
        return openedCount == 0;
    }

    static int[] getNumericRange(String choice) {
        int separator = choice.indexOf("..");
        if (separator < 0) {
            return null;
        }
        try {
            int start = Integer.parseInt(choice.substring(0, separator));
            int end = Integer.parseInt(choice.substring(separator + 2));
            return new int[]{start, end};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static int findChar(char c, char stopAt, String pattern, int length, int start) {
        int j;
        boolean escapedChar = false;
        for (j = start; j < length && (pattern.charAt(j) != stopAt || escapedChar); ++j) {
            if (pattern.charAt(j) == c && !escapedChar) {
                return j;
            }
            escapedChar = pattern.charAt(j) == '\\' && !escapedChar;
        }
        return -j;
    }

    static void escapeToRegex(char c, StringBuilder result) {
        if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-') {
            result.append(c);
        } else if (c == '\n') {
            result.append("\\n");
        } else {
            result.append('\\').append(c);
        }
    }
}

