/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.parser;

import java.util.Locale;
import java.util.regex.PatternSyntaxException;
import org.ec4j.core.PropertyTypeRegistry;
import org.ec4j.core.model.Glob;
import org.ec4j.core.model.PropertyType;
import org.ec4j.core.parser.EditorConfigHandler;
import org.ec4j.core.parser.ErrorEvent;
import org.ec4j.core.parser.Location;
import org.ec4j.core.parser.ParseContext;

public abstract class AbstractValidatingHandler
implements EditorConfigHandler {
    protected Location globStart;
    protected Location propertyValueStart;
    protected final PropertyTypeRegistry registry;
    protected PropertyType<?> type;

    public AbstractValidatingHandler(PropertyTypeRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void endGlob(ParseContext context, String globSource) {
        Glob glob = new Glob(globSource);
        PatternSyntaxException e = glob.getError();
        if (e != null) {
            String msg = String.format("The glob '%s' is not valid: %s", globSource, e.getMessage());
            context.getErrorHandler().error(context, new ErrorEvent(this.globStart, context.getLocation(), msg, ErrorEvent.ErrorType.INVALID_GLOB));
        }
        this.glob(context, glob);
        this.globStart = null;
    }

    @Override
    public void endPropertyName(ParseContext context, String name) {
        name = this.normalizePropertyName(name);
        this.type = this.registry.getType(name);
        if (this.type != null) {
            this.type(context, this.type);
        } else {
            this.name(context, name);
        }
    }

    @Override
    public void endPropertyValue(ParseContext context, String value) {
        PropertyType.PropertyValue<String> propValue;
        PropertyType.PropertyValue<String> propertyValue = propValue = this.type == null ? PropertyType.PropertyValue.valid(value, value) : this.type.parse(value);
        if (!propValue.isValid()) {
            context.getErrorHandler().error(context, new ErrorEvent(this.propertyValueStart, context.getLocation(), propValue.getErrorMessage(), ErrorEvent.ErrorType.INVALID_PROPERTY_VALUE));
        }
        this.propertyValue(context, propValue);
        this.type = null;
        this.propertyValueStart = null;
    }

    protected abstract void glob(ParseContext var1, Glob var2);

    protected abstract void name(ParseContext var1, String var2);

    protected String normalizePropertyName(String name) {
        return name == null ? null : name.toLowerCase(Locale.US);
    }

    protected abstract void propertyValue(ParseContext var1, PropertyType.PropertyValue<?> var2);

    @Override
    public void startGlob(ParseContext context) {
        this.globStart = context.getLocation();
    }

    @Override
    public void startPropertyName(ParseContext context) {
    }

    @Override
    public void startPropertyValue(ParseContext context) {
        this.propertyValueStart = context.getLocation();
    }

    protected abstract void type(ParseContext var1, PropertyType<?> var2);
}

