/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm;

import org.eclipse.persistence.internal.libraries.asm.ByteVector;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;

final class ModuleWriter
extends ModuleVisitor {
    private final ClassWriter cw;
    int size;
    int attributeCount;
    int attributesSize;
    private final int name;
    private final int access;
    private final int version;
    private int mainClass;
    private int packageCount;
    private ByteVector packages;
    private int requireCount;
    private ByteVector requires;
    private int exportCount;
    private ByteVector exports;
    private int openCount;
    private ByteVector opens;
    private int useCount;
    private ByteVector uses;
    private int provideCount;
    private ByteVector provides;

    ModuleWriter(ClassWriter classWriter, int n, int n2, int n3) {
        super(393216);
        this.cw = classWriter;
        this.size = 16;
        this.name = n;
        this.access = n2;
        this.version = n3;
    }

    @Override
    public void visitMainClass(String string) {
        if (this.mainClass == 0) {
            this.cw.newUTF8("ModuleMainClass");
            ++this.attributeCount;
            this.attributesSize += 8;
        }
        this.mainClass = this.cw.newClass(string);
    }

    @Override
    public void visitPackage(String string) {
        if (this.packages == null) {
            this.cw.newUTF8("ModulePackages");
            this.packages = new ByteVector();
            ++this.attributeCount;
            this.attributesSize += 8;
        }
        this.packages.putShort(this.cw.newPackage(string));
        ++this.packageCount;
        this.attributesSize += 2;
    }

    @Override
    public void visitRequire(String string, int n, String string2) {
        if (this.requires == null) {
            this.requires = new ByteVector();
        }
        this.requires.putShort(this.cw.newModule(string)).putShort(n).putShort(string2 == null ? 0 : this.cw.newUTF8(string2));
        ++this.requireCount;
        this.size += 6;
    }

    @Override
    public void visitExport(String string, int n, String ... stringArray) {
        if (this.exports == null) {
            this.exports = new ByteVector();
        }
        this.exports.putShort(this.cw.newPackage(string)).putShort(n);
        if (stringArray == null) {
            this.exports.putShort(0);
            this.size += 6;
        } else {
            this.exports.putShort(stringArray.length);
            for (String string2 : stringArray) {
                this.exports.putShort(this.cw.newModule(string2));
            }
            this.size += 6 + 2 * stringArray.length;
        }
        ++this.exportCount;
    }

    @Override
    public void visitOpen(String string, int n, String ... stringArray) {
        if (this.opens == null) {
            this.opens = new ByteVector();
        }
        this.opens.putShort(this.cw.newPackage(string)).putShort(n);
        if (stringArray == null) {
            this.opens.putShort(0);
            this.size += 6;
        } else {
            this.opens.putShort(stringArray.length);
            for (String string2 : stringArray) {
                this.opens.putShort(this.cw.newModule(string2));
            }
            this.size += 6 + 2 * stringArray.length;
        }
        ++this.openCount;
    }

    @Override
    public void visitUse(String string) {
        if (this.uses == null) {
            this.uses = new ByteVector();
        }
        this.uses.putShort(this.cw.newClass(string));
        ++this.useCount;
        this.size += 2;
    }

    @Override
    public void visitProvide(String string, String ... stringArray) {
        if (this.provides == null) {
            this.provides = new ByteVector();
        }
        this.provides.putShort(this.cw.newClass(string));
        this.provides.putShort(stringArray.length);
        for (String string2 : stringArray) {
            this.provides.putShort(this.cw.newClass(string2));
        }
        ++this.provideCount;
        this.size += 4 + 2 * stringArray.length;
    }

    @Override
    public void visitEnd() {
    }

    void putAttributes(ByteVector byteVector) {
        if (this.mainClass != 0) {
            byteVector.putShort(this.cw.newUTF8("ModuleMainClass")).putInt(2).putShort(this.mainClass);
        }
        if (this.packages != null) {
            byteVector.putShort(this.cw.newUTF8("ModulePackages")).putInt(2 + 2 * this.packageCount).putShort(this.packageCount).putByteArray(this.packages.data, 0, this.packages.length);
        }
    }

    void put(ByteVector byteVector) {
        byteVector.putInt(this.size);
        byteVector.putShort(this.name).putShort(this.access).putShort(this.version);
        byteVector.putShort(this.requireCount);
        if (this.requires != null) {
            byteVector.putByteArray(this.requires.data, 0, this.requires.length);
        }
        byteVector.putShort(this.exportCount);
        if (this.exports != null) {
            byteVector.putByteArray(this.exports.data, 0, this.exports.length);
        }
        byteVector.putShort(this.openCount);
        if (this.opens != null) {
            byteVector.putByteArray(this.opens.data, 0, this.opens.length);
        }
        byteVector.putShort(this.useCount);
        if (this.uses != null) {
            byteVector.putByteArray(this.uses.data, 0, this.uses.length);
        }
        byteVector.putShort(this.provideCount);
        if (this.provides != null) {
            byteVector.putByteArray(this.provides.data, 0, this.provides.length);
        }
    }
}

