/*
 * Copyright Terracotta, Inc.
 * Copyright IBM Corp. 2024, 2025
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ehcache.core.spi.service;

import org.ehcache.CachePersistenceException;
import org.ehcache.spi.persistence.PersistableResourceService;

/**
 * Resource service handling file level operations for disk tiers.
 */
public interface DiskResourceService extends PersistableResourceService {

  /**
   * Creates a new persistence context within the given space.
   *
   * @param identifier space to create within
   * @param name name of the context to create
   * @return a {@link FileBasedPersistenceContext}
   */
  FileBasedPersistenceContext createPersistenceContextWithin(PersistenceSpaceIdentifier<?> identifier, String name) throws CachePersistenceException;
}
