/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.FluentCacheConfigurationBuilder;
import org.ehcache.config.ResourcePools;
import org.ehcache.core.CacheConfigurationChangeEvent;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.CacheConfigurationProperty;
import org.ehcache.core.HumanReadable;
import org.ehcache.core.InternalRuntimeConfiguration;
import org.ehcache.core.events.EventListenerWrapper;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.event.EventType;
import org.ehcache.expiry.Expiry;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.spi.service.ServiceConfiguration;

class EhcacheRuntimeConfiguration<K, V>
implements CacheRuntimeConfiguration<K, V>,
InternalRuntimeConfiguration,
HumanReadable {
    private final CacheConfiguration<K, V> config;
    private final Collection<ServiceConfiguration<?, ?>> addedServiceConfigurations = new ArrayList();
    private volatile ResourcePools resourcePools;
    private final List<CacheConfigurationChangeListener> cacheConfigurationListenerList = new CopyOnWriteArrayList<CacheConfigurationChangeListener>();

    EhcacheRuntimeConfiguration(CacheConfiguration<K, V> config) {
        this.config = config;
        this.resourcePools = config.getResourcePools();
    }

    public synchronized void updateResourcePools(ResourcePools pools) {
        if (pools == null) {
            throw new NullPointerException("Pools to be updated cannot be null");
        }
        ResourcePools updatedResourcePools = this.config.getResourcePools().validateAndMerge(pools);
        this.fireCacheConfigurationChange(CacheConfigurationProperty.UPDATE_SIZE, this.config.getResourcePools(), updatedResourcePools);
        this.resourcePools = updatedResourcePools;
    }

    public Collection<ServiceConfiguration<?, ?>> getServiceConfigurations() {
        ArrayList configurations = new ArrayList(this.config.getServiceConfigurations());
        configurations.addAll(this.addedServiceConfigurations);
        return Collections.unmodifiableCollection(configurations);
    }

    public Class<K> getKeyType() {
        return this.config.getKeyType();
    }

    public Class<V> getValueType() {
        return this.config.getValueType();
    }

    public EvictionAdvisor<? super K, ? super V> getEvictionAdvisor() {
        return this.config.getEvictionAdvisor();
    }

    public ClassLoader getClassLoader() {
        return this.config.getClassLoader();
    }

    public Expiry<? super K, ? super V> getExpiry() {
        return this.config.getExpiry();
    }

    public ExpiryPolicy<? super K, ? super V> getExpiryPolicy() {
        return this.config.getExpiryPolicy();
    }

    public ResourcePools getResourcePools() {
        return this.resourcePools;
    }

    public FluentCacheConfigurationBuilder<K, V, ?> derive() {
        FluentCacheConfigurationBuilder builder = this.config.derive();
        for (ServiceConfiguration<?, ?> service : this.addedServiceConfigurations) {
            builder = builder.withService(service);
        }
        return builder.updateResourcePools(existing -> this.resourcePools);
    }

    @Override
    public boolean addCacheConfigurationListener(List<CacheConfigurationChangeListener> listeners) {
        return this.cacheConfigurationListenerList.addAll(listeners);
    }

    @Override
    public boolean removeCacheConfigurationListener(CacheConfigurationChangeListener listener) {
        return this.cacheConfigurationListenerList.remove(listener);
    }

    public synchronized void deregisterCacheEventListener(CacheEventListener<? super K, ? super V> listener) {
        this.fireCacheConfigurationChange(CacheConfigurationProperty.REMOVE_LISTENER, listener, listener);
    }

    public synchronized void registerCacheEventListener(CacheEventListener<? super K, ? super V> listener, EventOrdering ordering, EventFiring firing, Set<EventType> forEventTypes) {
        EventListenerWrapper<? super K, ? super V> listenerWrapper = new EventListenerWrapper<K, V>(listener, firing, ordering, EnumSet.copyOf(forEventTypes));
        this.fireCacheConfigurationChange(CacheConfigurationProperty.ADD_LISTENER, listenerWrapper, listenerWrapper);
    }

    private <T> Collection<T> copy(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        return Collections.unmodifiableCollection(new ArrayList<T>(collection));
    }

    private <T> void fireCacheConfigurationChange(CacheConfigurationProperty prop, T oldValue, T newValue) {
        if (oldValue != null && !oldValue.equals(newValue) || newValue != null) {
            for (CacheConfigurationChangeListener cacheConfigurationListener : this.cacheConfigurationListenerList) {
                cacheConfigurationListener.cacheConfigurationChange(new CacheConfigurationChangeEvent(prop, oldValue, newValue));
            }
        }
    }

    @Override
    public String readableString() {
        StringBuilder serviceConfigurationsToStringBuilder = new StringBuilder();
        for (ServiceConfiguration<?, ?> serviceConfiguration : this.getServiceConfigurations()) {
            serviceConfigurationsToStringBuilder.append("\n    ").append("- ");
            if (serviceConfiguration instanceof HumanReadable) {
                serviceConfigurationsToStringBuilder.append(((HumanReadable)serviceConfiguration).readableString()).append("\n");
                continue;
            }
            serviceConfigurationsToStringBuilder.append(serviceConfiguration.getClass().getName()).append("\n");
        }
        if (serviceConfigurationsToStringBuilder.length() > 0) {
            serviceConfigurationsToStringBuilder.deleteCharAt(serviceConfigurationsToStringBuilder.length() - 1);
        } else {
            serviceConfigurationsToStringBuilder.append(" None");
        }
        return "keyType: " + this.getKeyType().getName() + "\nvalueType: " + this.getValueType().getName() + "\nserviceConfigurations:" + serviceConfigurationsToStringBuilder.toString().replace("\n", "\n    ") + "\nevictionAdvisor: " + (this.getEvictionAdvisor() != null ? this.getEvictionAdvisor().getClass().getName() : "None") + "\nexpiry: " + this.getExpiryPolicy() + "\nresourcePools: \n    " + (this.resourcePools instanceof HumanReadable ? ((HumanReadable)this.resourcePools).readableString() : "").replace("\n", "\n    ");
    }
}

