/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import org.everit.json.schema.ObjectComparator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.internal.JSONPrinter;
import org.json.JSONArray;

public class ArraySchema
extends Schema {
    private final Integer minItems;
    private final Integer maxItems;
    private final boolean uniqueItems;
    private final Schema allItemSchema;
    private final boolean additionalItems;
    private final List<Schema> itemSchemas;
    private final boolean requiresArray;
    private final Schema schemaOfAdditionalItems;

    public static Builder builder() {
        return new Builder();
    }

    public ArraySchema(Builder builder) {
        super(builder);
        this.minItems = builder.minItems;
        this.maxItems = builder.maxItems;
        this.uniqueItems = builder.uniqueItems;
        this.allItemSchema = builder.allItemSchema;
        this.itemSchemas = builder.itemSchemas;
        this.additionalItems = !builder.additionalItems && this.allItemSchema != null ? true : builder.schemaOfAdditionalItems != null || builder.additionalItems;
        this.schemaOfAdditionalItems = builder.schemaOfAdditionalItems;
        if (this.allItemSchema != null && this.itemSchemas != null) {
            throw new SchemaException("cannot perform both tuple and list validation");
        }
        this.requiresArray = builder.requiresArray;
    }

    public Schema getAllItemSchema() {
        return this.allItemSchema;
    }

    public List<Schema> getItemSchemas() {
        return this.itemSchemas;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Schema getSchemaOfAdditionalItems() {
        return this.schemaOfAdditionalItems;
    }

    private Optional<ValidationException> ifFails(Schema schema, Object input) {
        try {
            schema.validate(input);
            return Optional.empty();
        }
        catch (ValidationException e) {
            return Optional.of(e);
        }
    }

    public boolean needsUniqueItems() {
        return this.uniqueItems;
    }

    public boolean permitsAdditionalItems() {
        return this.additionalItems;
    }

    public boolean requiresArray() {
        return this.requiresArray;
    }

    private Optional<ValidationException> testItemCount(JSONArray subject) {
        int actualLength = subject.length();
        if (this.minItems != null && actualLength < this.minItems) {
            return Optional.of(new ValidationException((Schema)this, "expected minimum item count: " + this.minItems + ", found: " + actualLength, "minItems"));
        }
        if (this.maxItems != null && this.maxItems < actualLength) {
            return Optional.of(new ValidationException((Schema)this, "expected maximum item count: " + this.maxItems + ", found: " + actualLength, "maxItems"));
        }
        return Optional.empty();
    }

    private List<ValidationException> testItems(JSONArray subject) {
        ArrayList<ValidationException> rval = new ArrayList<ValidationException>();
        if (this.allItemSchema != null) {
            this.validateItemsAgainstSchema(IntStream.range(0, subject.length()), subject, this.allItemSchema, rval::add);
        } else if (this.itemSchemas != null) {
            if (!this.additionalItems && subject.length() > this.itemSchemas.size()) {
                rval.add(new ValidationException((Schema)this, String.format("expected: [%d] array items, found: [%d]", this.itemSchemas.size(), subject.length()), "items"));
            }
            int itemValidationUntil = Math.min(subject.length(), this.itemSchemas.size());
            this.validateItemsAgainstSchema(IntStream.range(0, itemValidationUntil), subject, this.itemSchemas::get, rval::add);
            if (this.schemaOfAdditionalItems != null) {
                this.validateItemsAgainstSchema(IntStream.range(itemValidationUntil, subject.length()), subject, this.schemaOfAdditionalItems, rval::add);
            }
        }
        return rval;
    }

    private void validateItemsAgainstSchema(IntStream indices, JSONArray items, Schema schema, Consumer<ValidationException> failureCollector) {
        this.validateItemsAgainstSchema(indices, items, (int i) -> schema, failureCollector);
    }

    private void validateItemsAgainstSchema(IntStream indices, JSONArray items, IntFunction<Schema> schemaForIndex, Consumer<ValidationException> failureCollector) {
        for (int i : indices.toArray()) {
            String copyOfI = String.valueOf(i);
            this.ifFails(schemaForIndex.apply(i), items.get(i)).map(exc -> exc.prepend(copyOfI)).ifPresent(failureCollector);
        }
    }

    private Optional<ValidationException> testUniqueness(JSONArray subject) {
        if (subject.length() == 0) {
            return Optional.empty();
        }
        ArrayList<Object> uniqueItems = new ArrayList<Object>(subject.length());
        for (int i = 0; i < subject.length(); ++i) {
            Object item = subject.get(i);
            for (Object e : uniqueItems) {
                if (!ObjectComparator.deepEquals(e, item)) continue;
                return Optional.of(new ValidationException((Schema)this, "array items are not unique", "uniqueItems"));
            }
            uniqueItems.add(item);
        }
        return Optional.empty();
    }

    @Override
    public void validate(Object subject) {
        ArrayList<ValidationException> failures = new ArrayList<ValidationException>();
        if (!(subject instanceof JSONArray)) {
            if (this.requiresArray) {
                throw new ValidationException((Schema)this, JSONArray.class, subject);
            }
        } else {
            JSONArray arrSubject = (JSONArray)subject;
            this.testItemCount(arrSubject).ifPresent(failures::add);
            if (this.uniqueItems) {
                this.testUniqueness(arrSubject).ifPresent(failures::add);
            }
            failures.addAll(this.testItems(arrSubject));
        }
        ValidationException.throwFor(this, failures);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ArraySchema) {
            ArraySchema that = (ArraySchema)o;
            return that.canEqual(this) && this.uniqueItems == that.uniqueItems && this.additionalItems == that.additionalItems && this.requiresArray == that.requiresArray && Objects.equals(this.minItems, that.minItems) && Objects.equals(this.maxItems, that.maxItems) && Objects.equals(this.allItemSchema, that.allItemSchema) && Objects.equals(this.itemSchemas, that.itemSchemas) && Objects.equals(this.schemaOfAdditionalItems, that.schemaOfAdditionalItems) && super.equals(o);
        }
        return false;
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        if (this.requiresArray) {
            writer.key("type").value("array");
        }
        writer.ifTrue("uniqueItems", this.uniqueItems);
        writer.ifPresent("minItems", this.minItems);
        writer.ifPresent("maxItems", this.maxItems);
        writer.ifFalse("additionalItems", this.additionalItems);
        if (this.allItemSchema != null) {
            writer.key("items");
            this.allItemSchema.describeTo(writer);
        }
        if (this.itemSchemas != null) {
            writer.key("items");
            writer.array();
            this.itemSchemas.forEach(schema -> schema.describeTo(writer));
            writer.endArray();
        }
        if (this.schemaOfAdditionalItems != null) {
            writer.key("additionalItems");
            this.schemaOfAdditionalItems.describeTo(writer);
        }
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ArraySchema;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minItems, this.maxItems, this.uniqueItems, this.allItemSchema, this.additionalItems, this.itemSchemas, this.requiresArray, this.schemaOfAdditionalItems);
    }

    public static class Builder
    extends Schema.Builder<ArraySchema> {
        private boolean requiresArray = true;
        private Integer minItems;
        private Integer maxItems;
        private boolean uniqueItems = false;
        private Schema allItemSchema;
        private List<Schema> itemSchemas = null;
        private boolean additionalItems = true;
        private Schema schemaOfAdditionalItems;

        public Builder addItemSchema(Schema itemSchema) {
            if (this.itemSchemas == null) {
                this.itemSchemas = new ArrayList<Schema>();
            }
            this.itemSchemas.add(Objects.requireNonNull(itemSchema, "itemSchema cannot be null"));
            return this;
        }

        public Builder additionalItems(boolean additionalItems) {
            this.additionalItems = additionalItems;
            return this;
        }

        public Builder allItemSchema(Schema allItemSchema) {
            this.allItemSchema = allItemSchema;
            return this;
        }

        @Override
        public ArraySchema build() {
            return new ArraySchema(this);
        }

        public Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public Builder minItems(Integer minItems) {
            this.minItems = minItems;
            return this;
        }

        public Builder requiresArray(boolean requiresArray) {
            this.requiresArray = requiresArray;
            return this;
        }

        public Builder schemaOfAdditionalItems(Schema schemaOfAdditionalItems) {
            this.schemaOfAdditionalItems = schemaOfAdditionalItems;
            return this;
        }

        public Builder uniqueItems(boolean uniqueItems) {
            this.uniqueItems = uniqueItems;
            return this;
        }
    }
}

