/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 * Copyright (c) 1998-1999 IBM Corp. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.corba.ee.impl.corba;

abstract public class TypeCodeImplHelper
{
    private static String  _id = "IDL:omg.org/CORBA/TypeCode:1.0";

    public static void insert (org.omg.CORBA.Any a, org.omg.CORBA.TypeCode that)
    {
        org.omg.CORBA.portable.OutputStream out = a.create_output_stream ();
        a.type (type ());
        write (out, that);
        a.read_value (out.create_input_stream (), type ());
    }

    public static org.omg.CORBA.TypeCode extract (org.omg.CORBA.Any a)
    {
        return read (a.create_input_stream ());
    }

    private static org.omg.CORBA.TypeCode __typeCode = null;
    synchronized public static org.omg.CORBA.TypeCode type ()
    {
        if (__typeCode == null)
            {
                __typeCode = org.omg.CORBA.ORB.init ().get_primitive_tc (org.omg.CORBA.TCKind.tk_TypeCode);
            }
        return __typeCode;
    }

    public static String id ()
    {
        return _id;
    }

    public static org.omg.CORBA.TypeCode read (org.omg.CORBA.portable.InputStream istream)
    {
        return istream.read_TypeCode ();
    }

    public static void write (org.omg.CORBA.portable.OutputStream ostream, org.omg.CORBA.TypeCode value)
    {
        ostream.write_TypeCode (value);
    }

    public static void write (org.omg.CORBA.portable.OutputStream ostream, TypeCodeImpl value)
    {
        ostream.write_TypeCode (value);
    }

}
