module org.javamoney.moneta {
    /* transitive */ requires java.money;
    /* transitive */ requires java.logging;
    requires jakarta.annotation;
    /* static phase */ requires osgi.core;
    /* static phase */ requires osgi.annotation;
    requires okhttp3;

    exports org.javamoney.moneta;
    exports org.javamoney.moneta.format;
    exports org.javamoney.moneta.function;
    exports org.javamoney.moneta.spi;
    exports org.javamoney.moneta.spi.format;
    exports org.javamoney.moneta.spi.loader;
    exports org.javamoney.moneta.spi.loader.urlconnection;
    exports org.javamoney.moneta.spi.loader.okhttp;

    provides CurrencyProviderSpi with JDKCurrencyProvider, ConfigurableCurrencyUnitProvider;
    provides MonetaryAmountFactoryProviderSpi with MoneyAmountFactoryProvider, FastMoneyAmountFactoryProvider, RoundedMoneyAmountFactoryProvider;
    provides MonetaryAmountFormatProviderSpi with DefaultAmountFormatProviderSpi;
    provides MonetaryAmountsSingletonQuerySpi with DefaultMonetaryAmountsSingletonQuerySpi;
    provides MonetaryAmountsSingletonSpi with DefaultMonetaryAmountsSingletonSpi;
    provides MonetaryCurrenciesSingletonSpi with DefaultMonetaryCurrenciesSingletonSpi;
    provides RoundingProviderSpi with DefaultRoundingProvider;
    provides ServiceProvider with PriorityAwareServiceProvider;
    provides LoaderService with OkHttpLoaderService;
    provides MonetaryConfigProvider with DefaultConfigProvider;

}

