/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.MonetaryContext;
import javax.money.MonetaryException;
import javax.money.MonetaryOperator;
import javax.money.MonetaryQuery;
import javax.money.NumberValue;
import javax.money.format.MonetaryAmountFormat;
import org.javamoney.moneta.DefaultMonetaryContextFactory;
import org.javamoney.moneta.NumberVerifier;
import org.javamoney.moneta.format.MonetaryAmountDecimalFormat;
import org.javamoney.moneta.format.ToStringMonetaryAmountFormat;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.MonetaryConfig;
import org.javamoney.moneta.spi.MoneyAmountFactory;
import org.javamoney.moneta.spi.MoneyUtils;

public final class Money
implements MonetaryAmount,
Comparable<MonetaryAmount>,
Serializable {
    private static final long serialVersionUID = -7565813772046251748L;
    public static final MonetaryContext DEFAULT_MONETARY_CONTEXT = new DefaultMonetaryContextFactory().getContext();
    private final CurrencyUnit currency;
    private final MonetaryContext monetaryContext;
    private final BigDecimal number;

    private Money(BigDecimal number, CurrencyUnit currency) {
        this(number, currency, null);
    }

    private Money(BigDecimal number, CurrencyUnit currency, MonetaryContext monetaryContext) {
        Objects.requireNonNull(currency, "Currency is required.");
        this.currency = currency;
        this.monetaryContext = Objects.nonNull(monetaryContext) ? monetaryContext : DEFAULT_MONETARY_CONTEXT;
        Objects.requireNonNull(number, "Number is required.");
        this.number = MoneyUtils.getBigDecimal(number, this.monetaryContext);
    }

    public CurrencyUnit getCurrency() {
        return this.currency;
    }

    public MonetaryContext getContext() {
        return this.monetaryContext;
    }

    public NumberValue getNumber() {
        return new DefaultNumberValue(this.number);
    }

    public BigDecimal getNumberStripped() {
        if (this.isZero()) {
            return BigDecimal.ZERO;
        }
        return this.number.stripTrailingZeros();
    }

    @Override
    public int compareTo(MonetaryAmount o) {
        Objects.requireNonNull(o);
        int compare = this.getCurrency().getCurrencyCode().compareTo(o.getCurrency().getCurrencyCode());
        if (compare == 0) {
            compare = this.number.compareTo(Money.from((MonetaryAmount)o).number);
        }
        return compare;
    }

    public Money abs() {
        if (this.isPositiveOrZero()) {
            return this;
        }
        return this.negate();
    }

    public Money divide(long divisor) {
        if (divisor == 1L) {
            return this;
        }
        return this.divide(BigDecimal.valueOf(divisor));
    }

    public Money divide(double divisor) {
        if (NumberVerifier.isInfinityAndNotNaN(divisor)) {
            return Money.of((Number)0, this.getCurrency());
        }
        if (divisor == 1.0) {
            return this;
        }
        return this.divide(new BigDecimal(String.valueOf(divisor)));
    }

    public Money[] divideAndRemainder(long divisor) {
        return this.divideAndRemainder(BigDecimal.valueOf(divisor));
    }

    public Money[] divideAndRemainder(double divisor) {
        if (NumberVerifier.isInfinityAndNotNaN(divisor)) {
            Money zero = Money.of((Number)0, this.getCurrency());
            return new Money[]{zero, zero};
        }
        return this.divideAndRemainder(new BigDecimal(String.valueOf(divisor)));
    }

    public Money multiply(long multiplicand) {
        if (multiplicand == 1L) {
            return this;
        }
        return this.multiply(BigDecimal.valueOf(multiplicand));
    }

    public Money multiply(double multiplicand) {
        NumberVerifier.checkNoInfinityOrNaN(multiplicand);
        if (multiplicand == 1.0) {
            return this;
        }
        return this.multiply(new BigDecimal(String.valueOf(multiplicand)));
    }

    public Money remainder(long divisor) {
        return this.remainder(BigDecimal.valueOf(divisor));
    }

    public Money remainder(double divisor) {
        if (NumberVerifier.isInfinityAndNotNaN(divisor)) {
            return Money.of((Number)0, this.getCurrency());
        }
        return this.remainder(new BigDecimal(String.valueOf(divisor)));
    }

    public boolean isZero() {
        return this.signum() == 0;
    }

    public boolean isPositive() {
        return this.signum() == 1;
    }

    public boolean isPositiveOrZero() {
        return this.signum() >= 0;
    }

    public boolean isNegative() {
        return this.signum() == -1;
    }

    public boolean isNegativeOrZero() {
        return this.signum() <= 0;
    }

    public int getScale() {
        return this.number.scale();
    }

    public int getPrecision() {
        return this.number.precision();
    }

    public <R> R query(MonetaryQuery<R> query) {
        Objects.requireNonNull(query);
        try {
            return (R)query.queryFrom((MonetaryAmount)this);
        }
        catch (MonetaryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MonetaryException("Query failed: " + query, (Throwable)e);
        }
    }

    public Money with(MonetaryOperator operator) {
        Objects.requireNonNull(operator);
        try {
            return (Money)Money.class.cast(operator.apply((MonetaryAmount)this));
        }
        catch (MonetaryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MonetaryException("Operator failed: " + operator, (Throwable)e);
        }
    }

    public Money add(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        if (amount.isZero()) {
            return this;
        }
        MathContext mc = MoneyUtils.getMathContext(this.monetaryContext, RoundingMode.HALF_EVEN);
        return new Money(this.number.add((BigDecimal)amount.getNumber().numberValue(BigDecimal.class), mc), this.getCurrency(), this.monetaryContext);
    }

    public Money divide(Number divisor) {
        if (NumberVerifier.isInfinityAndNotNaN(divisor)) {
            return Money.of((Number)0, this.getCurrency());
        }
        BigDecimal divisorBD = MoneyUtils.getBigDecimal(divisor);
        if (divisorBD.equals(BigDecimal.ONE)) {
            return this;
        }
        MathContext mc = MoneyUtils.getMathContext(this.monetaryContext, RoundingMode.HALF_EVEN);
        int maxScale = this.monetaryContext.getMaxScale();
        if (maxScale > 0) {
            return new Money(this.number.divide(divisorBD, maxScale, mc.getRoundingMode()), this.getCurrency(), this.monetaryContext);
        }
        return new Money(this.number.divide(divisorBD, mc), this.getCurrency(), this.monetaryContext);
    }

    public Money[] divideAndRemainder(Number divisor) {
        if (NumberVerifier.isInfinityAndNotNaN(divisor)) {
            Money zero = Money.of((Number)0, this.getCurrency());
            return new Money[]{zero, zero};
        }
        BigDecimal divisorBD = MoneyUtils.getBigDecimal(divisor);
        if (divisorBD.equals(BigDecimal.ONE)) {
            return new Money[]{this, new Money(BigDecimal.ZERO, this.getCurrency())};
        }
        MathContext mc = MoneyUtils.getMathContext(this.monetaryContext, RoundingMode.HALF_EVEN);
        BigDecimal[] dec = this.number.divideAndRemainder(divisorBD, mc);
        return new Money[]{new Money(dec[0], this.getCurrency(), this.monetaryContext), new Money(dec[1], this.getCurrency(), this.monetaryContext)};
    }

    public Money divideToIntegralValue(long divisor) {
        return this.divideToIntegralValue(MoneyUtils.getBigDecimal(divisor));
    }

    public Money divideToIntegralValue(double divisor) {
        if (NumberVerifier.isInfinityAndNotNaN(divisor)) {
            return Money.of((Number)0, this.getCurrency());
        }
        return this.divideToIntegralValue(MoneyUtils.getBigDecimal(divisor));
    }

    public Money divideToIntegralValue(Number divisor) {
        if (NumberVerifier.isInfinityAndNotNaN(divisor)) {
            return Money.of((Number)0, this.getCurrency());
        }
        MathContext mc = MoneyUtils.getMathContext(this.monetaryContext, RoundingMode.HALF_EVEN);
        BigDecimal divisorBD = MoneyUtils.getBigDecimal(divisor);
        BigDecimal dec = this.number.divideToIntegralValue(divisorBD, mc);
        return new Money(dec, this.getCurrency(), this.monetaryContext);
    }

    public Money multiply(Number multiplicand) {
        NumberVerifier.checkNoInfinityOrNaN(multiplicand);
        BigDecimal multiplicandBD = MoneyUtils.getBigDecimal(multiplicand);
        if (multiplicandBD.equals(BigDecimal.ONE)) {
            return this;
        }
        MathContext mc = MoneyUtils.getMathContext(this.monetaryContext, RoundingMode.HALF_EVEN);
        BigDecimal dec = this.number.multiply(multiplicandBD, mc);
        return new Money(dec, this.getCurrency(), this.monetaryContext);
    }

    public Money negate() {
        return new Money(this.number.negate(), this.getCurrency());
    }

    public Money plus() {
        return this;
    }

    public Money subtract(MonetaryAmount subtrahend) {
        MoneyUtils.checkAmountParameter(subtrahend, this.currency);
        if (subtrahend.isZero()) {
            return this;
        }
        MathContext mc = MoneyUtils.getMathContext(this.monetaryContext, RoundingMode.HALF_EVEN);
        return new Money(this.number.subtract((BigDecimal)subtrahend.getNumber().numberValue(BigDecimal.class), mc), this.getCurrency(), this.monetaryContext);
    }

    public Money stripTrailingZeros() {
        if (this.isZero()) {
            return new Money(BigDecimal.ZERO, this.getCurrency());
        }
        return new Money(this.number.stripTrailingZeros(), this.getCurrency(), this.monetaryContext);
    }

    public Money remainder(Number divisor) {
        if (NumberVerifier.isInfinityAndNotNaN(divisor)) {
            return new Money(BigDecimal.ZERO, this.getCurrency());
        }
        MathContext mc = MoneyUtils.getMathContext(this.monetaryContext, RoundingMode.HALF_EVEN);
        BigDecimal bd = MoneyUtils.getBigDecimal(divisor);
        return new Money(this.number.remainder(bd, mc), this.getCurrency(), this.monetaryContext);
    }

    public Money scaleByPowerOfTen(int power) {
        return new Money(this.number.scaleByPowerOfTen(power), this.getCurrency(), this.monetaryContext);
    }

    public int signum() {
        return this.number.signum();
    }

    public boolean isLessThan(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) < 0;
    }

    public boolean isLessThanOrEqualTo(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) <= 0;
    }

    public boolean isGreaterThan(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) > 0;
    }

    public boolean isGreaterThanOrEqualTo(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) >= 0;
    }

    public boolean isEqualTo(MonetaryAmount amount) {
        MoneyUtils.checkAmountParameter(amount, this.currency);
        return this.number.stripTrailingZeros().compareTo(((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).stripTrailingZeros()) == 0;
    }

    public MonetaryAmountFactory<Money> getFactory() {
        return new MoneyAmountFactory().setAmount(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Money) {
            Money other = (Money)obj;
            return this.getCurrency().equals(other.getCurrency()) && this.number.compareTo(other.number) == 0;
        }
        return false;
    }

    public String toString() {
        try {
            return Money.defaultFormat().format((MonetaryAmount)this);
        }
        catch (Exception e) {
            return this.getCurrency().getCurrencyCode() + ' ' + this.number.toPlainString();
        }
    }

    public int hashCode() {
        return Objects.hash(this.getCurrency(), this.getNumberStripped());
    }

    public static Money of(BigDecimal number, CurrencyUnit currency) {
        return new Money(number, currency);
    }

    public static Money of(BigDecimal number, CurrencyUnit currency, MonetaryContext monetaryContext) {
        return new Money(number, currency, monetaryContext);
    }

    public static Money of(Number number, CurrencyUnit currency) {
        return new Money(MoneyUtils.getBigDecimal(number), currency);
    }

    public static Money of(Number number, CurrencyUnit currency, MonetaryContext monetaryContext) {
        return new Money(MoneyUtils.getBigDecimal(number), currency, monetaryContext);
    }

    public static Money of(Number number, String currencyCode) {
        return new Money(MoneyUtils.getBigDecimal(number), Monetary.getCurrency((String)currencyCode, (String[])new String[0]));
    }

    public static Money of(BigDecimal number, String currencyCode) {
        return new Money(number, Monetary.getCurrency((String)currencyCode, (String[])new String[0]));
    }

    public static Money of(Number number, String currencyCode, MonetaryContext monetaryContext) {
        return new Money(MoneyUtils.getBigDecimal(number), Monetary.getCurrency((String)currencyCode, (String[])new String[0]), monetaryContext);
    }

    public static Money of(BigDecimal number, String currencyCode, MonetaryContext monetaryContext) {
        return new Money(number, Monetary.getCurrency((String)currencyCode, (String[])new String[0]), monetaryContext);
    }

    public static Money zero(CurrencyUnit currency) {
        return new Money(BigDecimal.ZERO, currency);
    }

    public static Money ofMinor(CurrencyUnit currency, long amountMinor) {
        return Money.ofMinor(currency, amountMinor, currency.getDefaultFractionDigits());
    }

    public static Money ofMinor(CurrencyUnit currency, long amountMinor, int fractionDigits) {
        if (fractionDigits < 0) {
            throw new IllegalArgumentException("The fractionDigits cannot be negative");
        }
        return Money.of(BigDecimal.valueOf(amountMinor, fractionDigits), currency);
    }

    public static Money from(MonetaryAmount amt) {
        if (amt.getClass() == Money.class) {
            return (Money)amt;
        }
        return Money.of((BigDecimal)amt.getNumber().numberValue(BigDecimal.class), amt.getCurrency(), amt.getContext());
    }

    public static Money parse(CharSequence text) {
        return Money.parse(text, Money.defaultFormat());
    }

    public static Money parse(CharSequence text, MonetaryAmountFormat formatter) {
        return Money.from(formatter.parse(text));
    }

    private static MonetaryAmountFormat defaultFormat() {
        String useJDK = MonetaryConfig.getConfig().getOrDefault("org.javamoney.moneta.useJDKdefaultFormat", "false");
        try {
            if (Boolean.parseBoolean(useJDK)) {
                Logger.getLogger(Money.class.getName()).fine("Using JDK formatter for toString().");
                return MonetaryAmountDecimalFormat.of();
            }
            Logger.getLogger(Money.class.getName()).fine("Using default formatter for toString().");
            return ToStringMonetaryAmountFormat.of(ToStringMonetaryAmountFormat.ToStringMonetaryAmountFormatStyle.MONEY);
        }
        catch (Exception e) {
            Logger.getLogger(Money.class.getName()).log(Level.WARNING, "Invalid boolean parameter for 'org.javamoney.moneta.useJDKdefaultFormat', using default formatter for toString().");
            return ToStringMonetaryAmountFormat.of(ToStringMonetaryAmountFormat.ToStringMonetaryAmountFormatStyle.MONEY);
        }
    }

    @Deprecated
    public static boolean isInfinityAndNotNaN(Number number) {
        double dValue;
        return (Double.class == number.getClass() || Float.class == number.getClass()) && !Double.isNaN(dValue = number.doubleValue()) && Double.isInfinite(dValue);
    }

    @Deprecated
    public static void checkNoInfinityOrNaN(Number number) {
        NumberVerifier.checkNoInfinityOrNaN(number);
    }
}

