/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.spi.PriorityServiceComparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public final class OSGIServiceHelper {
    private static final Logger LOG = Logger.getLogger(OSGIServiceHelper.class.getName());

    private OSGIServiceHelper() {
    }

    public Enumeration<URL> getResources(BundleContext bundleContext, String resource) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading resources: " + resource);
        }
        ArrayList<URL> result = new ArrayList<URL>();
        URL url = bundleContext.getBundle().getEntry(resource);
        if (url != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Resource: " + resource + " found in unregistered bundle " + bundleContext.getBundle().getSymbolicName());
            }
            result.add(url);
        }
        for (Bundle bundle : bundleContext.getBundles()) {
            url = bundle.getEntry(resource);
            if (url == null || result.contains(url)) continue;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Resource: " + resource + " found in registered bundle " + bundle.getSymbolicName());
            }
            result.add(url);
        }
        for (Bundle bundle : bundleContext.getBundles()) {
            url = bundle.getEntry(resource);
            if (url == null || result.contains(url)) continue;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Resource: " + resource + " found in unregistered bundle " + bundle.getSymbolicName());
            }
            result.add(url);
        }
        return Collections.enumeration(result);
    }

    public static <T> void registerService(Bundle bundle, Class<T> serviceClass, Class<? extends T> implClass) {
        try {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Loaded Service Factory (" + serviceClass.getName() + "): " + implClass.getName());
            }
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("version", bundle.getVersion().toString());
            String vendor = (String)bundle.getHeaders().get("Bundle-Vendor");
            props.put("service.vendor", vendor != null ? vendor : "anonymous");
            props.put("service.ranking", PriorityServiceComparator.getPriority(implClass));
            JDKUtilServiceFactory<? extends T> factory = new JDKUtilServiceFactory<T>(implClass);
            BundleContext bundleContext = bundle.getBundleContext();
            bundleContext.registerService(serviceClass.getName(), factory, props);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Registered service class: " + implClass.getName() + "(" + serviceClass.getName() + ")");
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load service: " + implClass.getName(), e);
        }
    }

    public static <T> void unregisterService(Bundle bundle, Class<T> serviceClass, Class<? extends T> implClass) {
        try {
            ServiceReference ref;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Unloading Service (" + serviceClass.getName() + "): " + implClass.getName());
            }
            if ((ref = bundle.getBundleContext().getServiceReference(implClass)) != null) {
                bundle.getBundleContext().ungetService(ref);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to unload service: " + implClass.getName(), e);
        }
    }

    static class JDKUtilServiceFactory<S>
    implements ServiceFactory<S> {
        private final Class<? extends S> serviceClass;

        public JDKUtilServiceFactory(Class<? extends S> serviceClass) {
            this.serviceClass = serviceClass;
        }

        public S getService(Bundle bundle, ServiceRegistration<S> registration) {
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Creating Service...:" + this.serviceClass.getName());
                }
                return this.serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                String message = "Failed to create service: " + this.serviceClass.getName();
                LOG.log(Level.SEVERE, message, ex);
                throw new IllegalStateException(message, ex);
            }
        }

        public void ungetService(Bundle bundle, ServiceRegistration<S> registration, S service) {
        }
    }
}

