/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.format;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.format.AmountFormatContext;
import javax.money.format.AmountFormatContextBuilder;
import javax.money.format.MonetaryAmountFormat;
import javax.money.format.MonetaryParseException;
import org.javamoney.moneta.FastMoney;
import org.javamoney.moneta.Money;
import org.javamoney.moneta.RoundedMoney;
import org.javamoney.moneta.spi.MonetaryConfig;

public final class ToStringMonetaryAmountFormat
implements MonetaryAmountFormat {
    private static final String CONTEXT_PREFIX = "ToString_";
    private static final ToStringMonetaryAmountFormat INSTANCE_FASTMONEY = new ToStringMonetaryAmountFormat(ToStringMonetaryAmountFormatStyle.FAST_MONEY);
    private static final ToStringMonetaryAmountFormat INSTANCE_MONEY = new ToStringMonetaryAmountFormat(ToStringMonetaryAmountFormatStyle.MONEY);
    private static final ToStringMonetaryAmountFormat INSTANCE_ROUNDEDMONEY = new ToStringMonetaryAmountFormat(ToStringMonetaryAmountFormatStyle.ROUNDED_MONEY);
    private final ToStringMonetaryAmountFormatStyle style;
    private final AmountFormatContext context;

    private ToStringMonetaryAmountFormat(ToStringMonetaryAmountFormatStyle style) {
        this.style = Objects.requireNonNull(style);
        this.context = AmountFormatContextBuilder.of((String)(CONTEXT_PREFIX + (Object)((Object)style))).build();
    }

    public static ToStringMonetaryAmountFormat of(ToStringMonetaryAmountFormatStyle style) {
        switch (style) {
            case FAST_MONEY: {
                return INSTANCE_FASTMONEY;
            }
            case ROUNDED_MONEY: {
                return INSTANCE_ROUNDEDMONEY;
            }
        }
        return INSTANCE_MONEY;
    }

    public String queryFrom(MonetaryAmount amount) {
        return Optional.ofNullable(amount).map(m -> {
            String order;
            BigDecimal dec = (BigDecimal)amount.getNumber().numberValue(BigDecimal.class);
            int maxScale = amount.getContext().getMaxScale();
            int scale = 2;
            scale = amount instanceof FastMoney ? (maxScale == -1 ? dec.scale() : (dec.scale() < maxScale ? dec.scale() : maxScale)) : (amount.getContext().isFixedScale() ? (maxScale == -1 ? dec.scale() : maxScale) : (maxScale == -1 ? dec.scale() : (dec.scale() < maxScale ? dec.scale() : maxScale)));
            dec = dec.setScale(scale, RoundingMode.HALF_UP);
            switch (order = MonetaryConfig.getString("org.javamoney.toStringFormatOrder").orElse("ca")) {
                case "amount-currency": 
                case "amount currency": 
                case "ac": 
                case "a c": 
                case "a-c": {
                    return dec.toPlainString() + " " + m.getCurrency().getCurrencyCode();
                }
            }
            return m.getCurrency().getCurrencyCode() + " " + dec.toPlainString();
        }).orElse("null");
    }

    public AmountFormatContext getContext() {
        return this.context;
    }

    public void print(Appendable appendable, MonetaryAmount amount) throws IOException {
        appendable.append(this.queryFrom(amount));
    }

    public MonetaryAmount parse(CharSequence text) throws MonetaryParseException {
        try {
            ParserMonetaryAmount amount = this.parserMonetaryAmount(text);
            return this.style.to(amount);
        }
        catch (Exception e) {
            throw new MonetaryParseException(e.getMessage(), text, 0);
        }
    }

    private ParserMonetaryAmount parserMonetaryAmount(CharSequence text) {
        String[] array = Objects.requireNonNull(text).toString().split(" ");
        if (array.length != 2) {
            throw new MonetaryParseException("An error happened when try to parse the Monetary Amount.", text, 0);
        }
        try {
            CurrencyUnit currencyUnit = Monetary.getCurrency((String)array[1], (String[])new String[0]);
            BigDecimal number = new BigDecimal(array[0]);
            return new ParserMonetaryAmount(currencyUnit, number);
        }
        catch (Exception e) {
            CurrencyUnit currencyUnit = Monetary.getCurrency((String)array[0], (String[])new String[0]);
            BigDecimal number = new BigDecimal(array[1]);
            return new ParserMonetaryAmount(currencyUnit, number);
        }
    }

    public static enum ToStringMonetaryAmountFormatStyle {
        MONEY{

            @Override
            MonetaryAmount to(ParserMonetaryAmount amount) {
                return Money.of(amount.number, amount.currencyUnit);
            }
        }
        ,
        FAST_MONEY{

            @Override
            MonetaryAmount to(ParserMonetaryAmount amount) {
                return FastMoney.of((Number)amount.number, amount.currencyUnit);
            }
        }
        ,
        ROUNDED_MONEY{

            @Override
            MonetaryAmount to(ParserMonetaryAmount amount) {
                return RoundedMoney.of(amount.number, amount.currencyUnit);
            }
        };

        private static final long serialVersionUID = 6606016328162974467L;

        abstract MonetaryAmount to(ParserMonetaryAmount var1);
    }

    private static class ParserMonetaryAmount {
        private final CurrencyUnit currencyUnit;
        private final BigDecimal number;

        ParserMonetaryAmount(CurrencyUnit currencyUnit, BigDecimal number) {
            this.currencyUnit = currencyUnit;
            this.number = number;
        }
    }
}

