/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.MonetaryOperator;
import org.javamoney.moneta.function.ExtractorMajorPartOperator;
import org.javamoney.moneta.function.ExtractorMinorPartOperator;
import org.javamoney.moneta.function.PercentOperator;
import org.javamoney.moneta.function.PermilOperator;
import org.javamoney.moneta.function.ReciprocalOperator;
import org.javamoney.moneta.function.RoundingMonetaryAmountOperator;
import org.javamoney.moneta.spi.DefaultNumberValue;

public final class MonetaryOperators {
    private static final MathContext DEFAULT_MATH_CONTEXT = MathContext.DECIMAL64;
    private static final ReciprocalOperator RECIPROCAL = new ReciprocalOperator();
    private static final ExtractorMinorPartOperator EXTRACTOR_MINOR_PART = new ExtractorMinorPartOperator();
    private static final ExtractorMajorPartOperator EXTRACTOR_MAJOR_PART = new ExtractorMajorPartOperator();
    private static final RoundingMonetaryAmountOperator ROUNDING_MONETARY_AMOUNT = new RoundingMonetaryAmountOperator();

    private MonetaryOperators() {
    }

    public static MonetaryOperator reciprocal() {
        return RECIPROCAL;
    }

    public static MonetaryOperator permil(BigDecimal decimal) {
        return new PermilOperator(decimal);
    }

    public static MonetaryOperator permil(Number number) {
        return MonetaryOperators.permil(number, DEFAULT_MATH_CONTEXT);
    }

    public static MonetaryOperator permil(Number number, MathContext mathContext) {
        return new PermilOperator(new DefaultNumberValue(number).numberValue(BigDecimal.class));
    }

    public static MonetaryOperator percent(BigDecimal decimal) {
        return new PercentOperator(decimal);
    }

    public static MonetaryOperator percent(Number number) {
        return MonetaryOperators.percent(new DefaultNumberValue(number).numberValue(BigDecimal.class));
    }

    public static MonetaryOperator minorPart() {
        return EXTRACTOR_MINOR_PART;
    }

    public static MonetaryOperator majorPart() {
        return EXTRACTOR_MAJOR_PART;
    }

    public static MonetaryOperator rounding() {
        return ROUNDING_MONETARY_AMOUNT;
    }

    public static MonetaryOperator rounding(RoundingMode roundingMode) {
        return new RoundingMonetaryAmountOperator(Objects.requireNonNull(roundingMode));
    }

    public static MonetaryOperator rounding(RoundingMode roundingMode, int scale) {
        return new RoundingMonetaryAmountOperator(Objects.requireNonNull(roundingMode), scale);
    }

    public static MonetaryOperator rounding(int scale) {
        return new RoundingMonetaryAmountOperator(RoundingMonetaryAmountOperator.DEFAULT_ROUNDING_MONETARY_AMOUNT, scale);
    }
}

