/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.MonetaryAmount;
import javax.money.MonetaryOperator;
import javax.money.NumberValue;

final class ReciprocalOperator
implements MonetaryOperator {
    ReciprocalOperator() {
    }

    public MonetaryAmount apply(MonetaryAmount amount) {
        Objects.requireNonNull(amount, "Amount required.");
        NumberValue num = amount.getNumber();
        BigDecimal one = BigDecimal.ONE.setScale(num.getScale() < 5 ? 5 : num.getScale(), RoundingMode.HALF_EVEN);
        BigDecimal reciprocal = one.divide((BigDecimal)num.numberValue(BigDecimal.class), RoundingMode.HALF_EVEN);
        return amount.getFactory().setNumber((Number)reciprocal).create();
    }
}

