/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.OptionalInt;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryOperator;

class RoundingMonetaryAmountOperator
implements MonetaryOperator {
    static final RoundingMode DEFAULT_ROUNDING_MONETARY_AMOUNT = RoundingMode.HALF_EVEN;
    private final RoundingMode roundingMode;
    private final OptionalInt scaleOptional;

    public RoundingMonetaryAmountOperator() {
        this.roundingMode = DEFAULT_ROUNDING_MONETARY_AMOUNT;
        this.scaleOptional = OptionalInt.empty();
    }

    public RoundingMonetaryAmountOperator(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
        this.scaleOptional = OptionalInt.empty();
    }

    public RoundingMonetaryAmountOperator(RoundingMode roundingMode, int scale) {
        this.roundingMode = roundingMode;
        this.scaleOptional = OptionalInt.of(scale);
    }

    public MonetaryAmount apply(MonetaryAmount amount) {
        Objects.requireNonNull(amount, "Amount required.");
        CurrencyUnit currency = amount.getCurrency();
        int scale = this.scaleOptional.orElse(currency.getDefaultFractionDigits());
        BigDecimal value = ((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).setScale(scale, this.roundingMode);
        return amount.getFactory().setNumber((Number)value).create();
    }
}

