/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.util.logging.Logger;
import javax.money.spi.Bootstrap;
import javax.money.spi.CurrencyProviderSpi;
import javax.money.spi.MonetaryAmountFactoryProviderSpi;
import javax.money.spi.MonetaryAmountFormatProviderSpi;
import javax.money.spi.MonetaryAmountsSingletonQuerySpi;
import javax.money.spi.MonetaryAmountsSingletonSpi;
import javax.money.spi.MonetaryCurrenciesSingletonSpi;
import javax.money.spi.RoundingProviderSpi;
import javax.money.spi.ServiceProvider;
import org.javamoney.moneta.OSGIServiceHelper;
import org.javamoney.moneta.internal.OSGIServiceProvider;
import org.javamoney.moneta.spi.ConfigurableCurrencyUnitProvider;
import org.javamoney.moneta.spi.DefaultMonetaryAmountsSingletonQuerySpi;
import org.javamoney.moneta.spi.DefaultMonetaryAmountsSingletonSpi;
import org.javamoney.moneta.spi.DefaultMonetaryCurrenciesSingletonSpi;
import org.javamoney.moneta.spi.DefaultRoundingProvider;
import org.javamoney.moneta.spi.FastMoneyAmountFactoryProvider;
import org.javamoney.moneta.spi.JDKCurrencyProvider;
import org.javamoney.moneta.spi.MoneyAmountFactoryProvider;
import org.javamoney.moneta.spi.RoundedMoneyAmountFactoryProvider;
import org.javamoney.moneta.spi.format.DefaultAmountFormatProviderSpi;
import org.javamoney.moneta.spi.loader.LoaderService;
import org.javamoney.moneta.spi.loader.urlconnection.URLConnectionLoaderService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class OSGIActivator
implements BundleActivator {
    private static final Logger LOG = Logger.getLogger(OSGIActivator.class.getName());
    private volatile OSGIServiceProvider serviceProvider;

    public void start(BundleContext context) {
        this.serviceProvider = new OSGIServiceProvider(context);
        LOG.config("Registered OSGI ServiceProvider...");
        Bootstrap.init((ServiceProvider)this.serviceProvider);
        LOG.config("Registering JavaMoney services...");
        OSGIServiceHelper.registerService(context.getBundle(), CurrencyProviderSpi.class, JDKCurrencyProvider.class);
        OSGIServiceHelper.registerService(context.getBundle(), CurrencyProviderSpi.class, ConfigurableCurrencyUnitProvider.class);
        OSGIServiceHelper.registerService(context.getBundle(), MonetaryAmountFactoryProviderSpi.class, FastMoneyAmountFactoryProvider.class);
        OSGIServiceHelper.registerService(context.getBundle(), MonetaryAmountFactoryProviderSpi.class, MoneyAmountFactoryProvider.class);
        OSGIServiceHelper.registerService(context.getBundle(), MonetaryAmountFactoryProviderSpi.class, RoundedMoneyAmountFactoryProvider.class);
        OSGIServiceHelper.registerService(context.getBundle(), MonetaryAmountFormatProviderSpi.class, DefaultAmountFormatProviderSpi.class);
        OSGIServiceHelper.registerService(context.getBundle(), MonetaryAmountsSingletonQuerySpi.class, DefaultMonetaryAmountsSingletonQuerySpi.class);
        OSGIServiceHelper.registerService(context.getBundle(), MonetaryAmountsSingletonQuerySpi.class, DefaultMonetaryAmountsSingletonQuerySpi.class);
        OSGIServiceHelper.registerService(context.getBundle(), MonetaryAmountsSingletonSpi.class, DefaultMonetaryAmountsSingletonSpi.class);
        OSGIServiceHelper.registerService(context.getBundle(), MonetaryCurrenciesSingletonSpi.class, DefaultMonetaryCurrenciesSingletonSpi.class);
        OSGIServiceHelper.registerService(context.getBundle(), RoundingProviderSpi.class, DefaultRoundingProvider.class);
        OSGIServiceHelper.registerService(context.getBundle(), LoaderService.class, URLConnectionLoaderService.class);
        LOG.config("Registered JavaMoney services...");
    }

    public void stop(BundleContext context) {
        if (this.serviceProvider != null) {
            LOG.config("Unregistering JavaMoney services...");
            OSGIServiceHelper.unregisterService(context.getBundle(), CurrencyProviderSpi.class, JDKCurrencyProvider.class);
            OSGIServiceHelper.unregisterService(context.getBundle(), CurrencyProviderSpi.class, ConfigurableCurrencyUnitProvider.class);
            OSGIServiceHelper.unregisterService(context.getBundle(), MonetaryAmountFactoryProviderSpi.class, FastMoneyAmountFactoryProvider.class);
            OSGIServiceHelper.unregisterService(context.getBundle(), MonetaryAmountFactoryProviderSpi.class, MoneyAmountFactoryProvider.class);
            OSGIServiceHelper.unregisterService(context.getBundle(), MonetaryAmountFactoryProviderSpi.class, RoundedMoneyAmountFactoryProvider.class);
            OSGIServiceHelper.unregisterService(context.getBundle(), MonetaryAmountFormatProviderSpi.class, DefaultAmountFormatProviderSpi.class);
            OSGIServiceHelper.unregisterService(context.getBundle(), MonetaryAmountsSingletonQuerySpi.class, DefaultMonetaryAmountsSingletonQuerySpi.class);
            OSGIServiceHelper.unregisterService(context.getBundle(), MonetaryAmountsSingletonQuerySpi.class, DefaultMonetaryAmountsSingletonQuerySpi.class);
            OSGIServiceHelper.unregisterService(context.getBundle(), MonetaryAmountsSingletonSpi.class, DefaultMonetaryAmountsSingletonSpi.class);
            OSGIServiceHelper.unregisterService(context.getBundle(), MonetaryCurrenciesSingletonSpi.class, DefaultMonetaryCurrenciesSingletonSpi.class);
            OSGIServiceHelper.unregisterService(context.getBundle(), RoundingProviderSpi.class, DefaultRoundingProvider.class);
            OSGIServiceHelper.unregisterService(context.getBundle(), LoaderService.class, URLConnectionLoaderService.class);
        }
    }
}

