/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.Monetary;
import javax.money.spi.ServiceProvider;
import org.javamoney.moneta.internal.OSGIServiceComparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OSGIServiceProvider
implements ServiceProvider {
    private static final Logger LOG = Logger.getLogger(OSGIServiceProvider.class.getName());
    private static final OSGIServiceComparator REF_COMPARATOR = new OSGIServiceComparator();
    private final BundleContext bundleContext;

    public OSGIServiceProvider(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public boolean isInitialized() {
        return this.bundleContext != null;
    }

    public int getPriority() {
        return 10;
    }

    public <T> T getService(Class<T> serviceType) {
        ServiceReference ref;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading service: " + serviceType.getName());
        }
        if ((ref = this.bundleContext.getServiceReference(serviceType)) != null) {
            return (T)this.bundleContext.getService(ref);
        }
        return null;
    }

    public <T> T create(Class<T> serviceType) {
        ServiceReference ref;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Creating service: " + serviceType.getName());
        }
        if ((ref = this.bundleContext.getServiceReference(serviceType)) != null) {
            try {
                return (T)this.bundleContext.getService(ref).getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "could not create service of type: " + serviceType, e);
                return null;
            }
        }
        return null;
    }

    public <T> List<T> getServices(Class<T> serviceType) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading services: " + serviceType.getName());
        }
        ArrayList refs = new ArrayList();
        ArrayList<Object> services = new ArrayList<Object>(refs.size());
        try {
            refs.addAll(this.bundleContext.getServiceReferences(serviceType, null));
            refs.sort(REF_COMPARATOR);
            for (ServiceReference ref : refs) {
                Object service = this.bundleContext.getService(ref);
                if (service == null) continue;
                services.add(service);
            }
        }
        catch (InvalidSyntaxException e) {
            LOG.log(Level.SEVERE, "could not create services of type: " + serviceType, e);
        }
        try {
            for (T service : ServiceLoader.load(serviceType, Monetary.class.getClassLoader())) {
                services.add(service);
            }
            return services;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "could not create services of type: " + serviceType, e);
            return services;
        }
    }

    public Enumeration<URL> getResources(String resource, ClassLoader cl) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading resources: " + resource);
        }
        ArrayList<URL> result = new ArrayList<URL>();
        URL url = this.bundleContext.getBundle().getEntry(resource);
        if (url != null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(" Resource: " + resource + " found in unregistered bundle " + this.bundleContext.getBundle().getSymbolicName());
            }
            result.add(url);
        }
        for (Bundle bundle : this.bundleContext.getBundles()) {
            url = bundle.getEntry(resource);
            if (url == null || result.contains(url)) continue;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Resource: " + resource + " found in registered bundle " + bundle.getSymbolicName());
            }
            result.add(url);
        }
        for (Bundle bundle : this.bundleContext.getBundles()) {
            url = bundle.getEntry(resource);
            if (url == null || result.contains(url)) continue;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Resource: " + resource + " found in unregistered bundle " + bundle.getSymbolicName());
            }
            result.add(url);
        }
        return Collections.enumeration(result);
    }
}

