/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.money.CurrencyQuery;
import javax.money.CurrencyUnit;
import javax.money.spi.CurrencyProviderSpi;

public class ConfigurableCurrencyUnitProvider
implements CurrencyProviderSpi {
    private static final Map<String, CurrencyUnit> CURRENCY_UNITS = new ConcurrentHashMap<String, CurrencyUnit>();
    private static final Map<Integer, CurrencyUnit> CURRENCY_UNITS_BY_NUMERIC_CODE = new ConcurrentHashMap<Integer, CurrencyUnit>();
    private static final Map<Locale, CurrencyUnit> CURRENCY_UNITS_BY_LOCALE = new ConcurrentHashMap<Locale, CurrencyUnit>();

    public Set<CurrencyUnit> getCurrencies(CurrencyQuery currencyQuery) {
        HashSet<CurrencyUnit> result = new HashSet<CurrencyUnit>(CURRENCY_UNITS.size());
        if (currencyQuery.get(LocalDateTime.class) != null || currencyQuery.get(LocalDate.class) != null) {
            return Collections.emptySet();
        }
        if (!currencyQuery.getCurrencyCodes().isEmpty()) {
            for (String code : currencyQuery.getCurrencyCodes()) {
                CurrencyUnit cu = CURRENCY_UNITS.get(code);
                if (cu != null) {
                    result.add(cu);
                    continue;
                }
                Pattern pattern = Pattern.compile(code);
                CURRENCY_UNITS.keySet().stream().filter(k -> pattern.matcher((CharSequence)k).matches()).forEach(r -> result.add(CURRENCY_UNITS.get(r)));
            }
            return result;
        }
        if (!currencyQuery.getCountries().isEmpty()) {
            for (Locale locale : currencyQuery.getCountries()) {
                CurrencyUnit cu = CURRENCY_UNITS_BY_LOCALE.get(locale);
                if (cu == null) continue;
                result.add(cu);
            }
            return result;
        }
        if (!currencyQuery.getNumericCodes().isEmpty()) {
            for (Integer numericCode : currencyQuery.getNumericCodes()) {
                CurrencyUnit cu = CURRENCY_UNITS_BY_NUMERIC_CODE.get(numericCode);
                if (cu == null) continue;
                result.add(cu);
            }
            return result;
        }
        result.addAll(CURRENCY_UNITS.values());
        return result;
    }

    public static CurrencyUnit registerCurrencyUnit(CurrencyUnit currencyUnit) {
        Objects.requireNonNull(currencyUnit);
        CurrencyUnit registered = CURRENCY_UNITS.put(currencyUnit.getCurrencyCode(), currencyUnit);
        int numericCode = currencyUnit.getNumericCode();
        if (numericCode != -1) {
            CURRENCY_UNITS_BY_NUMERIC_CODE.put(numericCode, currencyUnit);
        }
        return registered;
    }

    public static CurrencyUnit registerCurrencyUnit(CurrencyUnit currencyUnit, Locale locale) {
        Objects.requireNonNull(locale);
        Objects.requireNonNull(currencyUnit);
        return CURRENCY_UNITS_BY_LOCALE.put(locale, currencyUnit);
    }

    public static CurrencyUnit removeCurrencyUnit(String currencyCode) {
        int numericCode;
        Objects.requireNonNull(currencyCode);
        CurrencyUnit removed = CURRENCY_UNITS.remove(currencyCode);
        if (removed != null && (numericCode = removed.getNumericCode()) != -1) {
            CURRENCY_UNITS_BY_NUMERIC_CODE.remove(numericCode);
        }
        return removed;
    }

    public static CurrencyUnit removeCurrencyUnit(Locale locale) {
        Objects.requireNonNull(locale);
        return CURRENCY_UNITS_BY_LOCALE.remove(locale);
    }

    public String toString() {
        return "ConfigurableCurrencyUnitProvider [CURRENCY_UNITS=" + CURRENCY_UNITS + ", CURRENCY_UNITS_BY_NUMERIC_CODE=" + CURRENCY_UNITS_BY_NUMERIC_CODE + ", CURRENCY_UNITS_BY_LOCALE=" + CURRENCY_UNITS_BY_LOCALE + ']';
    }
}

