/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryRounding;
import javax.money.RoundingContext;
import javax.money.RoundingContextBuilder;

final class DefaultCashRounding
implements MonetaryRounding,
Serializable {
    private static final long serialVersionUID = -117584984073879922L;
    private static final String SCALE_KEY = "scale";
    private static final String MINMINORS_KEY = "minimalMinors";
    private static final String PROVCLASS_KEY = "providerClass";
    private static final String CASHROUNDING_KEY = "cashRounding";
    private RoundingContext context;

    DefaultCashRounding(int scale, RoundingMode roundingMode, int minimalMinors) {
        if (scale < 0) {
            throw new IllegalArgumentException("scale < 0");
        }
        Objects.requireNonNull(roundingMode, "roundingMode missing");
        this.context = ((RoundingContextBuilder)((RoundingContextBuilder)((RoundingContextBuilder)((RoundingContextBuilder)((RoundingContextBuilder)RoundingContextBuilder.of((String)"default", (String)"default").set(CASHROUNDING_KEY, true)).set(PROVCLASS_KEY, (Object)this.getClass().getName())).set(MINMINORS_KEY, minimalMinors)).set(SCALE_KEY, scale)).set((Object)roundingMode)).build();
    }

    DefaultCashRounding(CurrencyUnit currency, RoundingMode roundingMode, int minimalMinors) {
        this(currency.getDefaultFractionDigits(), roundingMode, minimalMinors);
    }

    DefaultCashRounding(CurrencyUnit currency, int minimalMinors) {
        this(currency, RoundingMode.HALF_UP, minimalMinors);
    }

    public MonetaryAmount apply(MonetaryAmount amount) {
        Objects.requireNonNull(amount, "Amount required.");
        int scale = this.context.getInt(SCALE_KEY);
        RoundingMode roundingMode = (RoundingMode)((Object)this.context.get(RoundingMode.class));
        BigDecimal num = ((BigDecimal)amount.getNumber().numberValue(BigDecimal.class)).setScale(scale, roundingMode);
        long minors = num.movePointRight(num.scale()).longValueExact();
        int minimalMinors = this.context.getInt(MINMINORS_KEY);
        long factor = minors / (long)minimalMinors;
        long low = (long)minimalMinors * factor;
        long high = (long)minimalMinors * (factor + 1L);
        if (minors - low > high - minors) {
            minors = high;
        } else if (minors - low < high - minors) {
            minors = low;
        } else {
            switch (roundingMode) {
                case HALF_UP: 
                case UP: 
                case HALF_EVEN: {
                    minors = high;
                    break;
                }
                default: {
                    minors = low;
                }
            }
        }
        return amount.getFactory().setCurrency(amount.getCurrency()).setNumber((Number)BigDecimal.valueOf(minors, scale)).create();
    }

    public RoundingContext getRoundingContext() {
        return this.context;
    }
}

