/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.spi.MonetaryConfigProvider;

public class DefaultConfigProvider
implements MonetaryConfigProvider {
    private static final Logger LOG = Logger.getLogger(DefaultConfigProvider.class.getName());
    private final Map<String, Integer> priorities = new HashMap<String, Integer>();
    public final Map<String, String> config = new ConcurrentHashMap<String, String>();

    public DefaultConfigProvider() {
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources("javamoney.properties");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try {
                    Properties props = new Properties();
                    props.load(url.openStream());
                    this.updateConfig(props);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Error loading javamoney.properties, ignoring " + url, e);
                }
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error loading javamoney.properties.", e);
        }
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.config.put(k.toString(), v.toString())));
    }

    @Override
    public String getProperty(String key) {
        String sysProp = System.getProperty(key);
        if (sysProp != null) {
            return sysProp;
        }
        return this.getProperties().get(key);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.config;
    }

    private void updateConfig(Properties props) {
        for (Map.Entry<Object, Object> en : props.entrySet()) {
            Integer existingPrio;
            int index;
            String key = en.getKey().toString();
            String value = en.getValue().toString();
            int prio = 0;
            if (key.startsWith("{") && (index = key.indexOf(125)) > 0) {
                String prioString = key.substring(1, index);
                try {
                    prio = Integer.parseInt(prioString);
                    key = key.substring(index + 1);
                }
                catch (NumberFormatException e) {
                    LOG.warning("Invalid config key in javamoney.properties: " + key);
                }
            }
            if (Objects.isNull(existingPrio = this.priorities.get(key))) {
                this.priorities.put(key, prio);
                this.config.put(key, value);
                continue;
            }
            if (existingPrio < prio) {
                this.priorities.put(key, prio);
                this.config.put(key, value);
                continue;
            }
            if (existingPrio != prio) continue;
            LOG.warning("AmbiguousConfiguration detected for '" + key + "'.");
        }
    }
}

