/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyQuery;
import javax.money.CurrencyQueryBuilder;
import javax.money.CurrencyUnit;
import javax.money.spi.Bootstrap;
import javax.money.spi.CurrencyProviderSpi;
import javax.money.spi.MonetaryCurrenciesSingletonSpi;
import org.javamoney.moneta.spi.MonetaryConfig;

public class DefaultMonetaryCurrenciesSingletonSpi
implements MonetaryCurrenciesSingletonSpi {
    public Set<CurrencyUnit> getCurrencies(CurrencyQuery query) {
        HashSet<CurrencyUnit> result = new HashSet<CurrencyUnit>();
        List<CurrencyProviderSpi> providers = this.collectProviders(query);
        for (CurrencyProviderSpi spi : providers) {
            try {
                result.addAll(spi.getCurrencies(query));
            }
            catch (Exception e) {
                Logger.getLogger(DefaultMonetaryCurrenciesSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading currency provider names for " + spi.getClass().getName(), e);
            }
        }
        return result;
    }

    public boolean isCurrencyAvailable(String code, String ... providers) {
        return this.isCurrencyAvailable(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCurrencyCodes(new String[]{code}).setProviderNames(providers)).build());
    }

    public boolean isCurrencyAvailable(Locale locale, String ... providers) {
        return this.isCurrencyAvailable(((CurrencyQueryBuilder)CurrencyQueryBuilder.of().setCountries(new Locale[]{locale}).setProviderNames(providers)).build());
    }

    private boolean isCurrencyAvailable(CurrencyQuery query) {
        for (CurrencyProviderSpi provider : this.collectProviders(query)) {
            if (!provider.isCurrencyAvailable(query)) continue;
            return true;
        }
        return false;
    }

    private List<CurrencyProviderSpi> collectProviders(CurrencyQuery query) {
        ArrayList<CurrencyProviderSpi> result = new ArrayList<CurrencyProviderSpi>();
        if (!query.getProviderNames().isEmpty()) {
            for (String providerName : query.getProviderNames()) {
                CurrencyProviderSpi provider = this.getProvider(providerName);
                if (provider == null) {
                    Logger.getLogger(DefaultMonetaryCurrenciesSingletonSpi.class.getName()).warning("No such currency provider found, ignoring: " + providerName);
                    continue;
                }
                result.add(provider);
            }
        } else {
            for (String providerName : this.getDefaultProviderChain()) {
                CurrencyProviderSpi provider = this.getProvider(providerName);
                if (provider == null) {
                    Logger.getLogger(DefaultMonetaryCurrenciesSingletonSpi.class.getName()).warning("No such currency provider found, ignoring: " + providerName);
                    continue;
                }
                result.add(provider);
            }
        }
        return result;
    }

    private CurrencyProviderSpi getProvider(String providerName) {
        for (CurrencyProviderSpi provider : Bootstrap.getServices(CurrencyProviderSpi.class)) {
            if (!provider.getProviderName().equals(providerName)) continue;
            return provider;
        }
        return null;
    }

    public List<String> getDefaultProviderChain() {
        ArrayList<String> provList = new ArrayList<String>();
        String defaultChain = MonetaryConfig.getConfig().get("currencies.default-chain");
        if (defaultChain != null) {
            String[] items;
            for (String item : items = defaultChain.split(",")) {
                if (this.getProviderNames().contains(item.trim())) {
                    provList.add(item);
                    continue;
                }
                Logger.getLogger(this.getClass().getName()).warning("Ignoring non existing default provider: " + item);
            }
        } else {
            Bootstrap.getServices(CurrencyProviderSpi.class).forEach(p -> provList.add(p.getProviderName()));
        }
        return provList;
    }

    public Set<String> getProviderNames() {
        HashSet<String> result = new HashSet<String>();
        for (CurrencyProviderSpi spi : Bootstrap.getServices(CurrencyProviderSpi.class)) {
            try {
                result.add(spi.getProviderName());
            }
            catch (Exception e) {
                Logger.getLogger(DefaultMonetaryCurrenciesSingletonSpi.class.getName()).log(Level.SEVERE, "Error loading currency provider names for " + spi.getClass().getName(), e);
            }
        }
        return result;
    }
}

