/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryContext;
import javax.money.MonetaryException;
import org.javamoney.moneta.spi.ConvertBigDecimal;

public final class MoneyUtils {
    private static final Logger LOG = Logger.getLogger(MoneyUtils.class.getName());
    public static final String NBSP_STRING = "\u00a0";
    public static final String NNBSP_STRING = "\u202f";
    public static final char NBSP = "\u00a0".charAt(0);
    public static final char NNBSP = "\u202f".charAt(0);

    private MoneyUtils() {
    }

    public static BigDecimal getBigDecimal(long num) {
        return BigDecimal.valueOf(num);
    }

    public static BigDecimal getBigDecimal(double num) {
        if (Double.isNaN(num)) {
            throw new ArithmeticException("Invalid input Double.NaN.");
        }
        if (Double.isInfinite(num)) {
            throw new ArithmeticException("Invalid input Double.xxx_INFINITY.");
        }
        return new BigDecimal(String.valueOf(num));
    }

    public static BigDecimal getBigDecimal(Number num) {
        return ConvertBigDecimal.of(num);
    }

    public static BigDecimal getBigDecimal(Number num, MonetaryContext moneyContext) {
        BigDecimal bd = MoneyUtils.getBigDecimal(num);
        if (Objects.nonNull(moneyContext)) {
            MathContext mc = MoneyUtils.getMathContext(moneyContext, RoundingMode.HALF_EVEN);
            bd = new BigDecimal(bd.toString(), mc);
            int maxScale = moneyContext.getMaxScale();
            if (maxScale > 0 && bd.scale() > maxScale) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "The number scale is " + bd.scale() + " but Max Scale is " + maxScale);
                }
                bd = bd.setScale(maxScale, mc.getRoundingMode());
            }
        }
        return bd;
    }

    public static MathContext getMathContext(MonetaryContext monetaryContext, RoundingMode defaultMode) {
        MathContext ctx = (MathContext)monetaryContext.get(MathContext.class);
        if (Objects.nonNull(ctx)) {
            return ctx;
        }
        RoundingMode roundingMode = (RoundingMode)((Object)monetaryContext.get(RoundingMode.class));
        if (roundingMode == null) {
            roundingMode = Optional.ofNullable(defaultMode).orElse(RoundingMode.HALF_EVEN);
        }
        return new MathContext(monetaryContext.getPrecision(), roundingMode);
    }

    public static void checkAmountParameter(MonetaryAmount amount, CurrencyUnit currencyUnit) {
        Objects.requireNonNull(amount, "Amount must not be null.");
        CurrencyUnit amountCurrency = amount.getCurrency();
        if (!currencyUnit.getCurrencyCode().equals(amountCurrency.getCurrencyCode())) {
            throw new MonetaryException("Currency mismatch: " + currencyUnit + '/' + amountCurrency);
        }
    }

    public static void checkNumberParameter(Number number) {
        Objects.requireNonNull(number, "Number is required.");
    }

    public static String replaceNbspWithSpace(String s) {
        return s.replace(NBSP, ' ').replace(NNBSP, ' ');
    }
}

