/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.format;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import javax.money.MonetaryAmount;
import javax.money.format.AmountFormatContext;
import javax.money.format.MonetaryParseException;
import org.javamoney.moneta.spi.MoneyUtils;
import org.javamoney.moneta.spi.format.FormatToken;
import org.javamoney.moneta.spi.format.ParseContext;
import org.javamoney.moneta.spi.format.StringGrouper;

final class AmountNumberToken
implements FormatToken {
    private final AmountFormatContext amountFormatContext;
    private final String partialNumberPattern;
    private DecimalFormat parseFormat;
    private DecimalFormat formatFormat;
    private StringGrouper numberGroup;

    AmountNumberToken(AmountFormatContext amountFormatContext, String partialNumberPattern) {
        Objects.requireNonNull(amountFormatContext, "amountFormatContext is required.");
        Objects.requireNonNull(partialNumberPattern, "partialNumberPattern is required.");
        this.amountFormatContext = amountFormatContext;
        this.partialNumberPattern = MoneyUtils.replaceNbspWithSpace(partialNumberPattern);
        this.initDecimalFormats();
    }

    private void initDecimalFormats() {
        Locale locale = (Locale)this.amountFormatContext.get(Locale.class);
        this.formatFormat = (DecimalFormat)DecimalFormat.getInstance(locale);
        this.formatFormat.applyPattern(MoneyUtils.replaceNbspWithSpace(this.formatFormat.toPattern()));
        this.parseFormat = (DecimalFormat)this.formatFormat.clone();
        DecimalFormatSymbols syms = (DecimalFormatSymbols)this.amountFormatContext.get(DecimalFormatSymbols.class);
        syms = Objects.nonNull(syms) ? (DecimalFormatSymbols)syms.clone() : this.formatFormat.getDecimalFormatSymbols();
        this.fixThousandsSeparatorWithSpace(syms);
        this.formatFormat.setDecimalFormatSymbols(syms);
        this.parseFormat.setDecimalFormatSymbols(syms);
        this.formatFormat.applyPattern(this.partialNumberPattern);
        this.parseFormat.applyPattern(this.partialNumberPattern.trim());
    }

    private void fixThousandsSeparatorWithSpace(DecimalFormatSymbols symbols) {
        if (Character.isSpaceChar(this.formatFormat.getDecimalFormatSymbols().getGroupingSeparator())) {
            symbols.setGroupingSeparator(' ');
        }
        if (Character.isWhitespace(this.formatFormat.getDecimalFormatSymbols().getDecimalSeparator())) {
            symbols.setDecimalSeparator(' ');
        }
        if (Character.isWhitespace(this.formatFormat.getDecimalFormatSymbols().getMonetaryDecimalSeparator())) {
            symbols.setMonetaryDecimalSeparator(' ');
        }
    }

    public AmountFormatContext getAmountFormatContext() {
        return this.amountFormatContext;
    }

    public String getNumberPattern() {
        return this.partialNumberPattern;
    }

    @Override
    public void print(Appendable appendable, MonetaryAmount amount) throws IOException {
        int[] groupSizes = (int[])this.amountFormatContext.get("groupingSizes", int[].class);
        if (groupSizes == null || groupSizes.length == 0) {
            String preformattedValue = this.formatFormat.format(amount.getNumber().numberValue(BigDecimal.class));
            appendable.append(preformattedValue);
            return;
        }
        this.formatFormat.setGroupingUsed(false);
        String preformattedValue = this.formatFormat.format(amount.getNumber().numberValue(BigDecimal.class));
        String[] numberParts = this.splitNumberParts(this.formatFormat, preformattedValue);
        if (numberParts.length != 2) {
            appendable.append(preformattedValue);
        } else {
            if (Objects.isNull(this.numberGroup)) {
                char[] groupChars = (char[])this.amountFormatContext.get("groupingSeparators", char[].class);
                if (groupChars == null || groupChars.length == 0) {
                    char groupingSeparator = this.formatFormat.getDecimalFormatSymbols().getGroupingSeparator();
                    groupChars = new char[]{groupingSeparator};
                }
                this.numberGroup = new StringGrouper(groupChars, groupSizes);
            }
            preformattedValue = this.numberGroup.group(numberParts[0]) + this.formatFormat.getDecimalFormatSymbols().getDecimalSeparator() + numberParts[1];
            appendable.append(preformattedValue);
        }
    }

    private String[] splitNumberParts(DecimalFormat format, String preformattedValue) {
        char decimalSeparator = format.getDecimalFormatSymbols().getDecimalSeparator();
        int index = preformattedValue.indexOf(decimalSeparator);
        if (index < 0) {
            return new String[]{preformattedValue};
        }
        String beforeSeparator = preformattedValue.substring(0, index);
        String afterSeparator = preformattedValue.substring(index + 1);
        return new String[]{beforeSeparator, afterSeparator};
    }

    @Override
    public void parse(ParseContext context) throws MonetaryParseException {
        context.skipWhitespace();
        if (!context.isFullyParsed()) {
            this.parseToken(context);
            if (context.hasError()) {
                throw new MonetaryParseException(context.getErrorMessage(), context.getInput(), context.getIndex());
            }
        } else {
            context.setError();
            context.setErrorMessage("Number expected.");
        }
    }

    private void parseToken(ParseContext context) {
        ParsePosition pos = new ParsePosition(context.getIndex());
        String consumedInput = context.getInput().toString();
        int[] range = this.evalNumberRange(consumedInput);
        if (range[0] < 0) {
            context.setError();
            context.setErrorIndex(0);
            context.setErrorMessage("No digits found: \"" + context.getOriginalInput() + "\"");
            return;
        }
        String input = (consumedInput = consumedInput.substring(0, range[1] + 1)).substring(0, range[0]) + consumedInput.substring(range[0]).replace(" ", "").replace("\u00a0", "").replace("\u202f", "");
        Number number = this.parseFormat.parse(input, pos = new ParsePosition(0));
        if (Objects.nonNull(number)) {
            context.setParsedNumber(number);
            context.consume(consumedInput);
        } else {
            Logger.getLogger(this.getClass().getName()).finest("Could not parse amount from: " + context.getOriginalInput());
            context.setError();
            context.setErrorIndex(pos.getErrorIndex());
            context.setErrorMessage("Unparseable number: \"" + context.getOriginalInput() + "\"");
        }
    }

    private int[] evalNumberRange(String input) {
        int firstDigit = -1;
        int lastDigit = -1;
        for (int i = 0; i < input.length(); ++i) {
            if (Character.isDigit(input.charAt(i)) || input.charAt(i) == this.parseFormat.getDecimalFormatSymbols().getMinusSign() || input.charAt(i) == this.parseFormat.getDecimalFormatSymbols().getGroupingSeparator() || input.charAt(i) == this.parseFormat.getDecimalFormatSymbols().getDecimalSeparator() || input.charAt(i) == this.parseFormat.getDecimalFormatSymbols().getMonetaryDecimalSeparator() || input.charAt(i) == this.parseFormat.getDecimalFormatSymbols().getPercent() || input.charAt(i) == this.parseFormat.getDecimalFormatSymbols().getPerMill() || input.charAt(i) == this.parseFormat.getDecimalFormatSymbols().getZeroDigit()) {
                if (firstDigit < 0) {
                    firstDigit = i;
                }
                lastDigit = i;
                continue;
            }
            if (Character.isAlphabetic(input.charAt(i)) && firstDigit > 0) break;
        }
        return new int[]{firstDigit, lastDigit};
    }

    public String toString() {
        Locale locale = this.amountFormatContext.getLocale();
        return "AmountNumberToken [locale=" + locale + ", partialNumberPattern=" + this.partialNumberPattern + ']';
    }
}

