/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.format;

import java.io.IOException;
import java.util.Currency;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.format.AmountFormatContext;
import javax.money.format.MonetaryParseException;
import org.javamoney.moneta.format.CurrencyStyle;
import org.javamoney.moneta.spi.format.FormatToken;
import org.javamoney.moneta.spi.format.ParseContext;

final class CurrencyToken
implements FormatToken {
    private final AmountFormatContext context;
    private CurrencyStyle style = CurrencyStyle.CODE;
    private final Locale locale;

    CurrencyToken(CurrencyStyle style, AmountFormatContext context) {
        this.context = Objects.requireNonNull(context);
        this.locale = Objects.requireNonNull(context.getLocale(), "Locale null");
        if (Objects.nonNull((Object)style)) {
            this.style = style;
        }
    }

    public CurrencyToken setCurrencyStyle(CurrencyStyle style) {
        this.style = Objects.requireNonNull(style, "CurrencyStyle null");
        return this;
    }

    public CurrencyStyle getCurrencyStyle() {
        return this.style;
    }

    private String getToken(MonetaryAmount amount) {
        switch (this.style) {
            case NUMERIC_CODE: {
                return String.valueOf(amount.getCurrency().getNumericCode());
            }
            case NAME: {
                return this.getCurrencyName(amount.getCurrency());
            }
            case SYMBOL: {
                return this.getCurrencySymbol(amount.getCurrency());
            }
            case CODE: {
                return amount.getCurrency().getCurrencyCode();
            }
        }
        throw new UnsupportedOperationException("Unexpected style " + (Object)((Object)this.style));
    }

    private String getCurrencyName(CurrencyUnit currency) {
        Currency jdkCurrency = this.getCurrency(currency.getCurrencyCode());
        if (Objects.nonNull(jdkCurrency)) {
            return jdkCurrency.getDisplayName(this.locale);
        }
        return currency.getCurrencyCode();
    }

    private Currency getCurrency(String currencyCode) {
        try {
            return Currency.getInstance(currencyCode);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getCurrencySymbol(CurrencyUnit currency) {
        Currency jdkCurrency = this.getCurrency(currency.getCurrencyCode());
        if (Objects.nonNull(jdkCurrency)) {
            return jdkCurrency.getSymbol(this.locale);
        }
        return currency.getCurrencyCode();
    }

    @Override
    public void parse(ParseContext context) throws MonetaryParseException {
        String token = context.lookupNextToken();
        while (Objects.nonNull(token) && token.trim().isEmpty()) {
            context.consume(token);
            token = context.lookupNextToken();
        }
        if (token == null) {
            throw new MonetaryParseException("Error parsing CurrencyUnit: no input.", (CharSequence)"", -1);
        }
        try {
            CurrencyUnit cur;
            String[] stringArray;
            if (this.context.get("currencyProviderName", String.class) != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)this.context.get("currencyProviderName", String.class);
            } else {
                stringArray = new String[]{};
            }
            String[] providers = stringArray;
            switch (this.style) {
                case CODE: {
                    if (!Monetary.isCurrencyAvailable((String)token, (String[])providers)) {
                        String subCurrency = this.parseCurrencyCode(token);
                        cur = Monetary.getCurrency((String)subCurrency, (String[])providers);
                        context.consume(subCurrency);
                        break;
                    }
                    cur = Monetary.getCurrency((String)token, (String[])providers);
                    context.consume(token);
                    break;
                }
                case SYMBOL: {
                    if (token.startsWith("$")) {
                        throw new MonetaryParseException("$ is not a unique currency symbol.", (CharSequence)token, context.getErrorIndex());
                    }
                    if (token.startsWith("\u20ac")) {
                        cur = Monetary.getCurrency((String)"EUR", (String[])providers);
                        context.consume('\u20ac');
                    } else if (token.startsWith("\u00a3")) {
                        cur = Monetary.getCurrency((String)"GBP", (String[])providers);
                        context.consume('\u00a3');
                    } else {
                        String code = token;
                        for (Currency juc : Currency.getAvailableCurrencies()) {
                            if (!token.equals(juc.getSymbol())) continue;
                            code = juc.getCurrencyCode();
                            break;
                        }
                        cur = Monetary.getCurrency((String)code, (String[])providers);
                        context.consume(token);
                    }
                    context.setParsedCurrency(cur);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Not yet implemented");
                }
            }
            if (Objects.nonNull(cur)) {
                context.setParsedCurrency(cur);
            } else {
                CurrencyUnit fixed = (CurrencyUnit)this.context.get(CurrencyUnit.class);
                if (fixed != null) {
                    context.setParsedCurrency(fixed);
                }
            }
        }
        catch (MonetaryParseException e) {
            context.setError();
            context.setErrorMessage(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            context.setError();
            context.setErrorMessage(e.getMessage());
            Logger.getLogger(this.getClass().getName()).log(Level.FINEST, "Could not parse CurrencyUnit from \"" + token + "\"", e);
            throw new MonetaryParseException("Could not parse CurrencyUnit. " + e.getMessage(), (CharSequence)token, -1);
        }
    }

    private String parseCurrencyCode(String token) {
        int letterIndex = 0;
        for (char ch : token.toCharArray()) {
            if (Character.isLetter(ch)) {
                ++letterIndex;
                continue;
            }
            return token.substring(0, letterIndex);
        }
        return token;
    }

    @Override
    public void print(Appendable appendable, MonetaryAmount amount) throws IOException {
        appendable.append(this.getToken(amount));
    }

    public String toString() {
        return "CurrencyToken [locale=" + this.locale + ", style=" + (Object)((Object)this.style) + ']';
    }
}

