/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.format;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.money.AbstractContext;
import javax.money.format.AmountFormatContext;
import javax.money.format.AmountFormatContextBuilder;
import javax.money.format.AmountFormatQuery;
import javax.money.format.MonetaryAmountFormat;
import javax.money.spi.MonetaryAmountFormatProviderSpi;
import org.javamoney.moneta.spi.format.DefaultMonetaryAmountFormat;

public class DefaultAmountFormatProviderSpi
implements MonetaryAmountFormatProviderSpi {
    private static final String DEFAULT_STYLE = "default";
    private static final String PROVIDER_NAME = "default";
    private final Set<Locale> supportedSets = Collections.unmodifiableSet(new HashSet<Locale>(Arrays.asList(DecimalFormat.getAvailableLocales())));
    private final Set<String> formatNames = Collections.singleton("default");

    public String getProviderName() {
        return "default";
    }

    public Collection<MonetaryAmountFormat> getAmountFormats(AmountFormatQuery amountFormatQuery) {
        Objects.requireNonNull(amountFormatQuery, "AmountFormatContext required");
        if (!amountFormatQuery.getProviderNames().isEmpty() && !amountFormatQuery.getProviderNames().contains(this.getProviderName())) {
            return Collections.emptySet();
        }
        if (amountFormatQuery.getFormatName() != null && !"default".equals(amountFormatQuery.getFormatName())) {
            return Collections.emptySet();
        }
        AmountFormatContextBuilder builder = AmountFormatContextBuilder.of((String)"default");
        if (amountFormatQuery.getLocale() != null) {
            builder.setLocale(amountFormatQuery.getLocale());
        }
        builder.importContext((AbstractContext)amountFormatQuery, false);
        builder.setMonetaryAmountFactory(amountFormatQuery.getMonetaryAmountFactory());
        AmountFormatContext amountFormatContext = builder.build();
        return Arrays.asList(new DefaultMonetaryAmountFormat(amountFormatContext));
    }

    public Set<Locale> getAvailableLocales() {
        return this.supportedSets;
    }

    public Set<String> getAvailableFormatNames() {
        return this.formatNames;
    }
}

