/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.format;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.MonetaryAmountFactory;
import javax.money.format.AmountFormatContext;
import javax.money.format.AmountFormatContextBuilder;
import javax.money.format.MonetaryAmountFormat;
import javax.money.format.MonetaryParseException;
import org.javamoney.moneta.format.CurrencyStyle;
import org.javamoney.moneta.spi.MoneyUtils;
import org.javamoney.moneta.spi.format.AmountNumberToken;
import org.javamoney.moneta.spi.format.CurrencyToken;
import org.javamoney.moneta.spi.format.FormatToken;
import org.javamoney.moneta.spi.format.LiteralToken;
import org.javamoney.moneta.spi.format.ParseContext;

final class DefaultMonetaryAmountFormat
implements MonetaryAmountFormat {
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char SUBPATTERN_BOUNDARY = ';';
    private List<FormatToken> positiveTokens;
    private List<FormatToken> negativeTokens;
    private AmountFormatContext amountFormatContext;

    DefaultMonetaryAmountFormat(AmountFormatContext amountFormatContext) {
        Locale locale = amountFormatContext.getLocale();
        if (locale != null && "IN".equals(locale.getCountry()) && amountFormatContext.get("groupingSizes", int[].class) == null) {
            amountFormatContext = ((AmountFormatContextBuilder)amountFormatContext.toBuilder().set("groupingSizes", (Object)new int[]{3, 2})).build();
        }
        if (locale != null && "BG".equals(locale.getCountry())) {
            AmountFormatContextBuilder builder = amountFormatContext.toBuilder();
            if (amountFormatContext.get("groupingSizes", int[].class) == null) {
                ((AmountFormatContextBuilder)builder.set("groupingSizes", (Object)new int[]{3})).build();
            }
            if (amountFormatContext.get("groupingSeparators", int[].class) == null) {
                ((AmountFormatContextBuilder)builder.set("groupingSeparators", (Object)new String[]{"\u00a0"})).build();
            }
            amountFormatContext = builder.build();
        }
        this.setAmountFormatContext(amountFormatContext);
    }

    public String format(MonetaryAmount amount) {
        StringBuilder builder = new StringBuilder();
        try {
            this.print(builder, amount);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error formatting of " + amount, e);
        }
        return builder.toString();
    }

    public void print(Appendable appendable, MonetaryAmount amount) throws IOException {
        List<FormatToken> tokens = amount.isNegative() ? this.negativeTokens : this.positiveTokens;
        for (FormatToken token : tokens) {
            token.print(appendable, amount);
        }
    }

    public MonetaryAmount parse(CharSequence text) throws MonetaryParseException {
        CurrencyUnit unit;
        text = MoneyUtils.replaceNbspWithSpace(text.toString()).trim();
        ParseContext ctx = new ParseContext(text);
        try {
            for (FormatToken token : this.positiveTokens) {
                token.parse(ctx);
            }
        }
        catch (Exception e) {
            Logger log = Logger.getLogger(this.getClass().getName());
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Failed to parse positive pattern, trying negative for: " + text, e);
            }
            for (FormatToken token : this.negativeTokens) {
                token.parse(ctx);
            }
        }
        if (Objects.isNull(unit = ctx.getParsedCurrency())) {
            unit = (CurrencyUnit)this.amountFormatContext.get(CurrencyUnit.class);
        }
        if (Objects.isNull(unit)) {
            throw new MonetaryParseException("Failed to parse currency. Is currency sign \u00a4 present in pattern?", (CharSequence)text.toString(), -1);
        }
        Number num = ctx.getParsedNumber();
        if (Objects.isNull(num)) {
            throw new MonetaryParseException("Failed to parse amount", (CharSequence)text.toString(), -1);
        }
        MonetaryAmountFactory factory = this.amountFormatContext.getParseFactory();
        if (factory == null) {
            factory = Monetary.getDefaultAmountFactory();
        }
        return factory.setCurrency(unit).setNumber(num).create();
    }

    public String queryFrom(MonetaryAmount amount) {
        return this.format(amount);
    }

    public AmountFormatContext getContext() {
        return this.amountFormatContext;
    }

    private void setAmountFormatContext(AmountFormatContext amountFormatContext) {
        this.amountFormatContext = Objects.requireNonNull(amountFormatContext);
        String pattern = this.resolvePattern(amountFormatContext);
        String[] plusMinusPatterns = this.splitIntoPlusMinusPatterns(amountFormatContext, pattern);
        String positivePattern = plusMinusPatterns[0];
        this.positiveTokens = this.initPattern(positivePattern, amountFormatContext);
        if (plusMinusPatterns.length > 1) {
            String negativePattern = plusMinusPatterns[1];
            String pattern1 = negativePattern.replace("-", "");
            this.negativeTokens = this.initPattern(pattern1, amountFormatContext);
        } else {
            this.negativeTokens = this.positiveTokens;
        }
    }

    private String resolvePattern(AmountFormatContext amountFormatContext) {
        String pattern = amountFormatContext.getText("pattern");
        if (pattern == null) {
            DecimalFormat currencyDecimalFormat = (DecimalFormat)DecimalFormat.getCurrencyInstance(amountFormatContext.getLocale());
            pattern = MoneyUtils.replaceNbspWithSpace(currencyDecimalFormat.toPattern());
        }
        return pattern;
    }

    private String[] splitIntoPlusMinusPatterns(AmountFormatContext amountFormatContext, String pattern) {
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)amountFormatContext.get(DecimalFormatSymbols.class);
        char patternSeparator = decimalFormatSymbols != null ? (char)decimalFormatSymbols.getPatternSeparator() : (char)';';
        return pattern.split(String.valueOf(patternSeparator));
    }

    private List<FormatToken> initPattern(String pattern, AmountFormatContext context) {
        Locale locale = (Locale)context.get(Locale.class);
        DecimalFormat format = (DecimalFormat)DecimalFormat.getCurrencyInstance(locale);
        CurrencyStyle currencyStyle = (CurrencyStyle)((Object)context.get(CurrencyStyle.class));
        List<String> patternParts = this.tokenizePattern(pattern, format);
        ArrayList<FormatToken> tokens = new ArrayList<FormatToken>(3);
        for (String p : patternParts) {
            if (this.isNumberToken(p)) {
                tokens.add(new AmountNumberToken(context, p.substring(4)));
                continue;
            }
            if (this.isCurrencyToken(p)) {
                tokens.add(new CurrencyToken(currencyStyle, context));
                continue;
            }
            if (p.isEmpty()) continue;
            tokens.add(new LiteralToken(p));
        }
        return tokens;
    }

    private boolean isNumberToken(String token) {
        return token.startsWith("NUM:");
    }

    private boolean isCurrencyToken(String token) {
        return token.length() == 0 || token.charAt(0) == '\u00a4';
    }

    private List<String> tokenizePattern(String pattern, DecimalFormat format) {
        List<String> result = this.splitPatternForCurrency(pattern);
        return this.splitNumberPattern(result, format);
    }

    private List<String> splitPatternForCurrency(String pattern) {
        ArrayList<String> result = new ArrayList<String>();
        int index = pattern.indexOf(164);
        if (index < 0) {
            result.add(pattern);
        } else {
            String p = pattern.substring(0, index);
            if (!p.isEmpty()) {
                result.add(p);
            }
            result.add("\u00a4");
            p = pattern.substring(index + 1);
            if (!p.isEmpty()) {
                result.add(p);
            }
        }
        return result;
    }

    private List<String> splitNumberPattern(List<String> tokens, DecimalFormat format) {
        String part1;
        String part0;
        int index;
        ArrayList<String> result = new ArrayList<String>();
        String numberPattern = format.toLocalizedPattern().replace("\u00a4", "").trim();
        for (String token : tokens) {
            index = token.indexOf(numberPattern);
            if (index > 0) {
                part0 = token.substring(0, index);
                if (!part0.isEmpty()) {
                    result.add(part0);
                }
                result.add("NUM:" + numberPattern);
                part1 = token.substring(index + numberPattern.length());
                if (part1.isEmpty()) continue;
                result.add(part1);
                continue;
            }
            result.add(token);
        }
        if (result.size() == tokens.size()) {
            result.clear();
            for (String token : tokens) {
                numberPattern = this.getNumberPattern(token, format);
                if (numberPattern == null) {
                    result.add(token);
                    continue;
                }
                index = token.indexOf(numberPattern);
                part0 = token.substring(0, index);
                if (!part0.isEmpty()) {
                    result.add(part0);
                }
                result.add("NUM:" + numberPattern);
                part1 = token.substring(index + numberPattern.length());
                if (part1.isEmpty()) continue;
                result.add(part1);
            }
        }
        return result;
    }

    private String getNumberPattern(String token, DecimalFormat format) {
        int first = -1;
        int last = -1;
        DecimalFormatSymbols syms = format.getDecimalFormatSymbols();
        char[] chars = token.toCharArray();
        int nonMatching = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == syms.getMonetaryDecimalSeparator() || chars[i] == syms.getMonetaryDecimalSeparator() || chars[i] == syms.getDecimalSeparator() || chars[i] == syms.getGroupingSeparator() || chars[i] == syms.getMinusSign() || chars[i] == syms.getPercent() || chars[i] == syms.getPerMill() || chars[i] == syms.getZeroDigit() || chars[i] == syms.getDigit()) {
                if (first < 0) {
                    first = i;
                }
                last = i;
                nonMatching = 0;
            } else {
                ++nonMatching;
            }
            if (last != -1 && first < last && nonMatching > 2) break;
        }
        if (last != -1 && first < last) {
            return token.substring(first, last + 1);
        }
        return null;
    }
}

