/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.format;

import java.text.ParsePosition;
import java.util.Objects;
import javax.money.CurrencyUnit;

final class ParseContext {
    private int index;
    private int errorIndex = -1;
    private final CharSequence originalInput;
    private CurrencyUnit parsedCurrency;
    private Number parsedNumber;
    private String errorMessage;

    ParseContext(CharSequence text) {
        Objects.requireNonNull(text, "text is required");
        this.originalInput = text.toString();
    }

    public boolean isComplete() {
        return Objects.nonNull(this.parsedNumber) && Objects.nonNull(this.parsedCurrency);
    }

    public Number getParsedNumber() {
        return this.parsedNumber;
    }

    public boolean consume(String token) {
        if (this.getInput().toString().startsWith(token)) {
            this.index += token.length();
            return true;
        }
        return false;
    }

    public boolean consume(char c) {
        if (this.originalInput.charAt(this.index) == c) {
            ++this.index;
            return true;
        }
        return false;
    }

    public int skipWhitespace() {
        char ch;
        for (int i = this.index; i < this.originalInput.length() && Character.isSpaceChar(ch = this.originalInput.charAt(i)); ++i) {
            ++this.index;
        }
        return this.index;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    public void setErrorIndex(int index) {
        this.errorIndex = index;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setError() {
        this.errorIndex = this.index;
    }

    public int getIndex() {
        return this.index;
    }

    public CharSequence getInput() {
        return this.originalInput.subSequence(this.index, this.originalInput.length());
    }

    public String getOriginalInput() {
        return this.originalInput.toString();
    }

    public void reset() {
        this.index = 0;
        this.errorIndex = -1;
        this.parsedNumber = null;
        this.parsedCurrency = null;
        this.errorMessage = null;
    }

    public void setParsedNumber(Number number) {
        this.parsedNumber = Objects.requireNonNull(number);
    }

    public void setParsedCurrency(CurrencyUnit currency) {
        this.parsedCurrency = Objects.requireNonNull(currency);
    }

    public boolean hasError() {
        return this.errorIndex >= 0;
    }

    public boolean isFullyParsed() {
        return this.index == this.originalInput.length();
    }

    public String lookupNextToken() {
        this.skipWhitespace();
        int start = this.index;
        for (int end = this.index; end < this.originalInput.length(); ++end) {
            char ch = this.originalInput.charAt(end);
            if (!Character.isSpaceChar(ch)) continue;
            if (end > start) {
                return this.originalInput.subSequence(start, end).toString();
            }
            return null;
        }
        if (start < this.originalInput.length()) {
            return this.originalInput.subSequence(start, this.originalInput.length()).toString();
        }
        return null;
    }

    public ParsePosition toParsePosition() {
        return new ParsePosition(this.index);
    }

    public String toString() {
        return "ParseContext [index=" + this.index + ", errorIndex=" + this.errorIndex + ", originalInput='" + this.originalInput + "', parsedNumber=" + this.parsedNumber + "', parsedCurrency=" + this.parsedCurrency + ']';
    }

    public CurrencyUnit getParsedCurrency() {
        return this.parsedCurrency;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = Objects.requireNonNull(message);
    }
}

