/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader;

import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.javamoney.moneta.spi.loader.LoaderService;

public class LoadDataInformation {
    private final String resourceId;
    private final LoaderService.UpdatePolicy updatePolicy;
    private final Map<String, String> properties;
    private final LoaderService.Listener listener;
    private final URI backupResource;
    private final URI[] resourceLocations;
    private final boolean startRemote;

    LoadDataInformation(String resourceId, LoaderService.UpdatePolicy updatePolicy, Map<String, String> properties, LoaderService.Listener listener, URI backupResource, URI[] resourceLocations, boolean startRemote) {
        this.resourceId = resourceId;
        this.updatePolicy = updatePolicy;
        this.properties = properties;
        this.listener = listener;
        this.backupResource = backupResource;
        this.resourceLocations = resourceLocations;
        this.startRemote = startRemote;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public LoaderService.UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public LoaderService.Listener getLoaderListener() {
        return this.listener;
    }

    public URI getBackupResource() {
        return this.backupResource;
    }

    public URI[] getResourceLocations() {
        return this.resourceLocations;
    }

    public boolean isStartRemote() {
        return this.startRemote;
    }

    public int hashCode() {
        return Objects.hashCode(this.resourceId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (LoadDataInformation.class.isInstance(obj)) {
            LoadDataInformation other = (LoadDataInformation)LoadDataInformation.class.cast(obj);
            return Objects.equals(other.resourceId, this.resourceId);
        }
        return false;
    }

    public String toString() {
        return LoadDataInformation.class.getName() + '{' + " resourceId: " + this.resourceId + ',' + " updatePolicy: " + (Object)((Object)this.updatePolicy) + ',' + " properties: " + this.properties + ',' + " Listener: " + this.listener + ',' + " backupResource: " + this.backupResource + ',' + " resourceLocations: " + Arrays.toString(this.resourceLocations) + '}';
    }
}

