/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.javamoney.moneta.spi.loader.LoadDataInformation;
import org.javamoney.moneta.spi.loader.LoaderService;

public class LoadDataInformationBuilder {
    private String resourceId;
    private LoaderService.UpdatePolicy updatePolicy;
    private Map<String, String> properties;
    private LoaderService.Listener listener;
    private URI backupResource;
    private URI[] resourceLocations;
    private boolean startRemote;

    public LoadDataInformationBuilder withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public LoadDataInformationBuilder withUpdatePolicy(LoaderService.UpdatePolicy updatePolicy) {
        this.updatePolicy = updatePolicy;
        return this;
    }

    public LoadDataInformationBuilder withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public LoadDataInformationBuilder withLoaderListener(LoaderService.Listener listener) {
        this.listener = listener;
        return this;
    }

    public LoadDataInformationBuilder withBackupResource(URI backupResource) {
        this.backupResource = backupResource;
        return this;
    }

    public LoadDataInformationBuilder withResourceLocations(URI ... resourceLocations) {
        this.resourceLocations = resourceLocations;
        return this;
    }

    public LoadDataInformationBuilder withStartRemote(boolean startRemote) {
        this.startRemote = startRemote;
        return this;
    }

    public LoadDataInformation build() {
        if (Objects.isNull(this.resourceId) || this.resourceId.isEmpty()) {
            throw new IllegalStateException("The resourceId should be informed");
        }
        if (Objects.isNull((Object)this.updatePolicy)) {
            throw new IllegalStateException("The updatePolicy should be informed");
        }
        if (Objects.isNull(this.properties)) {
            throw new IllegalStateException("The properties should be informed");
        }
        if (Objects.isNull(this.resourceLocations)) {
            throw new IllegalStateException("The properties should be informed");
        }
        return new LoadDataInformation(this.resourceId, this.updatePolicy, this.properties, this.listener, this.backupResource, this.resourceLocations, this.startRemote);
    }
}

