/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.spi.loader.DataStreamFactory;
import org.javamoney.moneta.spi.loader.LoaderService;

public class LoaderListener {
    private static final Logger LOG = Logger.getLogger(LoaderListener.class.getName());
    private final Map<String, List<LoaderService.Listener>> listenersMap = new ConcurrentHashMap<String, List<LoaderService.Listener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoaderService.Listener> getListeners(String dataId) {
        List<LoaderService.Listener> listeners;
        if (Objects.isNull(dataId)) {
            dataId = "";
        }
        if (Objects.isNull(listeners = this.listenersMap.get(dataId))) {
            Map<String, List<LoaderService.Listener>> map = this.listenersMap;
            synchronized (map) {
                listeners = this.listenersMap.get(dataId);
                if (Objects.isNull(listeners)) {
                    listeners = Collections.synchronizedList(new ArrayList());
                    this.listenersMap.put(dataId, listeners);
                }
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(String dataId, DataStreamFactory dataStreamFactory) {
        List<LoaderService.Listener> listeners;
        List<LoaderService.Listener> list = listeners = this.getListeners("");
        synchronized (list) {
            for (LoaderService.Listener ll : listeners) {
                try {
                    ll.newDataLoaded(dataId, dataStreamFactory.getDataStream());
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Error calling LoadListener: " + ll, e);
                }
            }
        }
        if (!Objects.isNull(dataId) && !dataId.isEmpty()) {
            list = listeners = this.getListeners(dataId);
            synchronized (list) {
                for (LoaderService.Listener ll : listeners) {
                    try {
                        ll.newDataLoaded(dataId, dataStreamFactory.getDataStream());
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to load new data: " + ll, e);
                    }
                }
            }
        }
    }

    public String toString() {
        return LoaderListener.class.getName() + '{' + "listenersMap: " + this.listenersMap + '}';
    }
}

