/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader.okhttp;

import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.spi.loader.LoaderListener;
import org.javamoney.moneta.spi.loader.okhttp.LoadableHttpResource;

class HttpLoadLocalDataService {
    private static final Logger LOG = Logger.getLogger(HttpLoadLocalDataService.class.getName());
    private final Map<String, LoadableHttpResource> resources;
    private final LoaderListener listener;

    HttpLoadLocalDataService(Map<String, LoadableHttpResource> resources, LoaderListener listener) {
        this.resources = resources;
        this.listener = listener;
    }

    public boolean execute(String resourceId) {
        LoadableHttpResource load = this.resources.get(resourceId);
        if (Objects.nonNull(load)) {
            try {
                if (load.loadFallback()) {
                    this.listener.trigger(resourceId, load);
                    return true;
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to load resource locally: " + resourceId, e);
            }
        } else {
            throw new IllegalArgumentException("No such resource: " + resourceId);
        }
        return false;
    }

    public String toString() {
        return HttpLoadLocalDataService.class.getName() + '{' + " resources: " + this.resources + ", defaultLoaderListener: " + this.listener + '}';
    }
}

