/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader.okhttp;

import java.util.Objects;
import org.javamoney.moneta.spi.loader.LoadDataInformation;
import org.javamoney.moneta.spi.loader.ResourceCache;
import org.javamoney.moneta.spi.loader.okhttp.LoadableHttpResource;

class LoadableHttpResourceBuilder {
    private LoadDataInformation loadDataInformation;
    private ResourceCache cache;

    LoadableHttpResourceBuilder() {
    }

    public LoadableHttpResourceBuilder withLoadDataInformation(LoadDataInformation loadDataInformation) {
        this.loadDataInformation = loadDataInformation;
        return this;
    }

    public LoadableHttpResourceBuilder withCache(ResourceCache cache) {
        this.cache = cache;
        return this;
    }

    public LoadableHttpResource build() {
        if (Objects.isNull(this.cache)) {
            throw new IllegalStateException("The cache should be present");
        }
        if (Objects.isNull(this.loadDataInformation)) {
            throw new IllegalStateException("The loadDataInformation should be present");
        }
        return new LoadableHttpResource(this.cache, this.loadDataInformation);
    }

    public String toString() {
        return LoadableHttpResourceBuilder.class.getName() + '{' + " loadDataInformation: " + this.loadDataInformation + ',' + " cache: " + this.loadDataInformation + '}';
    }
}

