/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader.okhttp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.spi.Bootstrap;
import org.javamoney.moneta.spi.loader.DaemonThreadFactory;
import org.javamoney.moneta.spi.loader.LoadDataInformation;
import org.javamoney.moneta.spi.loader.LoadDataInformationBuilder;
import org.javamoney.moneta.spi.loader.LoaderConfigurator;
import org.javamoney.moneta.spi.loader.LoaderListener;
import org.javamoney.moneta.spi.loader.LoaderService;
import org.javamoney.moneta.spi.loader.ResourceCache;
import org.javamoney.moneta.spi.loader.okhttp.LoadableHttpResource;
import org.javamoney.moneta.spi.loader.okhttp.LoadableHttpResourceBuilder;
import org.javamoney.moneta.spi.loader.okhttp.OkHttpLoaderServiceFacade;
import org.javamoney.moneta.spi.loader.okhttp.OkHttpResourceCache;

public class OkHttpLoaderService
implements LoaderService {
    private static final Logger LOG = Logger.getLogger(OkHttpLoaderService.class.getName());
    private final Map<String, LoadableHttpResource> resources = new ConcurrentHashMap<String, LoadableHttpResource>();
    private final LoaderListener listener = new LoaderListener();
    private static final ResourceCache CACHE = OkHttpLoaderService.loadResourceCache();
    private final ExecutorService executors = Executors.newCachedThreadPool(DaemonThreadFactory.INSTANCE);
    private OkHttpLoaderServiceFacade defaultLoaderServiceFacade;
    private volatile Timer timer;

    public OkHttpLoaderService() {
        this.initialize();
    }

    void initialize() {
        Timer oldTimer = this.timer;
        this.timer = new Timer(true);
        if (Objects.nonNull(oldTimer)) {
            oldTimer.cancel();
        }
        LoaderConfigurator configurator = LoaderConfigurator.of(this);
        this.defaultLoaderServiceFacade = new OkHttpLoaderServiceFacade(this.timer, this.listener, this.resources);
        configurator.load();
    }

    private static ResourceCache loadResourceCache() {
        try {
            return Optional.ofNullable((ResourceCache)Bootstrap.getService(ResourceCache.class)).orElseGet(OkHttpResourceCache::new);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error loading ResourceCache instance.", e);
            return new OkHttpResourceCache();
        }
    }

    static ResourceCache getResourceCache() {
        return CACHE;
    }

    public void unload(String resourceId) {
        LoadableHttpResource res = this.resources.get(resourceId);
        if (Objects.nonNull(res)) {
            res.unload();
        }
    }

    @Override
    public void registerData(LoadDataInformation loadDataInformation) {
        if (this.resources.containsKey(loadDataInformation.getResourceId())) {
            throw new IllegalArgumentException("Resource : " + loadDataInformation.getResourceId() + " already registered.");
        }
        LoadableHttpResource resource = new LoadableHttpResourceBuilder().withCache(CACHE).withLoadDataInformation(loadDataInformation).build();
        this.resources.put(loadDataInformation.getResourceId(), resource);
        if (loadDataInformation.getLoaderListener() != null) {
            this.addLoaderListener(loadDataInformation.getLoaderListener(), loadDataInformation.getResourceId());
        }
        if (loadDataInformation.isStartRemote()) {
            this.defaultLoaderServiceFacade.loadDataRemote(loadDataInformation.getResourceId(), this.resources);
        }
        switch (loadDataInformation.getUpdatePolicy()) {
            case NEVER: {
                this.loadDataLocal(loadDataInformation.getResourceId());
                break;
            }
            case ONSTARTUP: {
                this.loadDataAsync(loadDataInformation.getResourceId());
                break;
            }
            case SCHEDULED: {
                this.defaultLoaderServiceFacade.scheduledData(resource);
                break;
            }
        }
    }

    @Override
    public void registerAndLoadData(LoadDataInformation loadDataInformation) {
        this.registerData(loadDataInformation);
        this.loadData(loadDataInformation.getResourceId());
    }

    @Override
    public void registerAndLoadData(String resourceId, LoaderService.UpdatePolicy updatePolicy, Map<String, String> properties, LoaderService.Listener listener, URI backupResource, URI ... resourceLocations) {
        this.registerAndLoadData(new LoadDataInformationBuilder().withResourceId(resourceId).withUpdatePolicy(updatePolicy).withProperties(properties).withLoaderListener(listener).withBackupResource(backupResource).withResourceLocations(resourceLocations).build());
    }

    @Override
    public void registerData(String resourceId, LoaderService.UpdatePolicy updatePolicy, Map<String, String> properties, LoaderService.Listener listener, URI backupResource, URI ... resourceLocations) {
        if (this.resources.containsKey(resourceId)) {
            throw new IllegalArgumentException("Resource : " + resourceId + " already registered.");
        }
        LoadDataInformation loadInfo = new LoadDataInformationBuilder().withResourceId(resourceId).withUpdatePolicy(updatePolicy).withProperties(properties).withLoaderListener(listener).withBackupResource(backupResource).withResourceLocations(resourceLocations).build();
        LoadableHttpResource resource = new LoadableHttpResourceBuilder().withCache(CACHE).withLoadDataInformation(loadInfo).build();
        this.resources.put(loadInfo.getResourceId(), resource);
        if (loadInfo.getLoaderListener() != null) {
            this.addLoaderListener(loadInfo.getLoaderListener(), loadInfo.getResourceId());
        }
        switch (loadInfo.getUpdatePolicy()) {
            case SCHEDULED: {
                this.defaultLoaderServiceFacade.scheduledData(resource);
                break;
            }
        }
    }

    @Override
    public Map<String, String> getUpdateConfiguration(String resourceId) {
        LoadableHttpResource load = this.resources.get(resourceId);
        if (Objects.nonNull(load)) {
            return load.getProperties();
        }
        return null;
    }

    @Override
    public boolean isResourceRegistered(String resourceId) {
        return this.resources.containsKey(resourceId);
    }

    @Override
    public Set<String> getResourceIds() {
        return this.resources.keySet();
    }

    @Override
    public InputStream getData(String resourceId) throws IOException {
        LoadableHttpResource load = this.resources.get(resourceId);
        if (Objects.nonNull(load)) {
            return load.getDataStream();
        }
        throw new IllegalArgumentException("No such resource: " + resourceId);
    }

    @Override
    public boolean loadData(String resourceId) {
        return this.defaultLoaderServiceFacade.loadData(resourceId, this.resources);
    }

    @Override
    public Future<Boolean> loadDataAsync(String resourceId) {
        return this.executors.submit(() -> this.defaultLoaderServiceFacade.loadData(resourceId, this.resources));
    }

    @Override
    public boolean loadDataLocal(String resourceId) {
        return this.defaultLoaderServiceFacade.loadDataLocal(resourceId);
    }

    @Override
    public void resetData(String resourceId) throws IOException {
        LoadableHttpResource load = Optional.ofNullable(this.resources.get(resourceId)).orElseThrow(() -> new IllegalArgumentException("No such resource: " + resourceId));
        if (load.resetToFallback()) {
            this.listener.trigger(resourceId, load);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLoaderListener(LoaderService.Listener l, String ... resourceIds) {
        if (resourceIds.length == 0) {
            List<LoaderService.Listener> listeners;
            List<LoaderService.Listener> list = listeners = this.listener.getListeners("");
            synchronized (list) {
                listeners.add(l);
            }
        } else {
            for (String dataId : resourceIds) {
                List<LoaderService.Listener> listeners;
                List<LoaderService.Listener> list = listeners = this.listener.getListeners(dataId);
                synchronized (list) {
                    listeners.add(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLoaderListener(LoaderService.Listener loadListener, String ... resourceIds) {
        if (resourceIds.length == 0) {
            List<LoaderService.Listener> listeners;
            List<LoaderService.Listener> list = listeners = this.listener.getListeners("");
            synchronized (list) {
                listeners.remove(loadListener);
            }
        } else {
            for (String dataId : resourceIds) {
                List<LoaderService.Listener> listeners;
                List<LoaderService.Listener> list = listeners = this.listener.getListeners(dataId);
                synchronized (list) {
                    listeners.remove(loadListener);
                }
            }
        }
    }

    @Override
    public LoaderService.UpdatePolicy getUpdatePolicy(String resourceId) {
        LoadableHttpResource load = Optional.of(this.resources.get(resourceId)).orElseThrow(() -> new IllegalArgumentException("No such resource: " + resourceId));
        return load.getUpdatePolicy();
    }

    public String toString() {
        return "URLConnectionLoaderService [resources=" + this.resources + ']';
    }
}

