/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader.okhttp;

import java.util.Map;
import java.util.Timer;
import org.javamoney.moneta.spi.loader.LoaderListener;
import org.javamoney.moneta.spi.loader.okhttp.HttpLoadDataService;
import org.javamoney.moneta.spi.loader.okhttp.HttpLoadLocalDataService;
import org.javamoney.moneta.spi.loader.okhttp.HttpLoadRemoteDataService;
import org.javamoney.moneta.spi.loader.okhttp.LoadableHttpResource;
import org.javamoney.moneta.spi.loader.okhttp.OkHttpScheduler;

class OkHttpLoaderServiceFacade {
    private final OkHttpScheduler scheduledDataLoaderService;
    private final HttpLoadDataService loadDataLoaderService;
    private final HttpLoadLocalDataService loadDataLocalLoaderService;
    private final HttpLoadRemoteDataService loadRemoteDataLoaderService;

    OkHttpLoaderServiceFacade(Timer timer, LoaderListener listener, Map<String, LoadableHttpResource> resources) {
        this.scheduledDataLoaderService = new OkHttpScheduler(timer, listener);
        this.loadDataLoaderService = new HttpLoadDataService(listener);
        this.loadDataLocalLoaderService = new HttpLoadLocalDataService(resources, listener);
        this.loadRemoteDataLoaderService = new HttpLoadRemoteDataService(listener);
    }

    public void scheduledData(LoadableHttpResource load) {
        this.scheduledDataLoaderService.execute(load);
    }

    public boolean loadData(String resourceId, Map<String, LoadableHttpResource> resources) {
        return this.loadDataLoaderService.execute(resourceId, resources);
    }

    public boolean loadDataLocal(String resourceId) {
        return this.loadDataLocalLoaderService.execute(resourceId);
    }

    public boolean loadDataRemote(String resourceId, Map<String, LoadableHttpResource> resources) {
        return this.loadRemoteDataLoaderService.execute(resourceId, resources);
    }

    public String toString() {
        return OkHttpLoaderServiceFacade.class.getName() + '{' + " scheduledDataLoaderService: " + this.scheduledDataLoaderService + ',' + " asyncLoaderService: " + this.loadDataLoaderService + ',' + " loadDataLocalLoaderService: " + this.loadDataLocalLoaderService + ',';
    }
}

