/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader.urlconnection;

import java.util.Objects;
import org.javamoney.moneta.spi.loader.LoadDataInformation;
import org.javamoney.moneta.spi.loader.ResourceCache;
import org.javamoney.moneta.spi.loader.urlconnection.LoadableURLResource;

class LoadableURLResourceBuilder {
    private LoadDataInformation loadDataInformation;
    private ResourceCache cache;

    LoadableURLResourceBuilder() {
    }

    public LoadableURLResourceBuilder withLoadDataInformation(LoadDataInformation loadDataInformation) {
        this.loadDataInformation = loadDataInformation;
        return this;
    }

    public LoadableURLResourceBuilder withCache(ResourceCache cache) {
        this.cache = cache;
        return this;
    }

    public LoadableURLResource build() {
        if (Objects.isNull(this.cache)) {
            throw new IllegalStateException("The cache should be informed");
        }
        if (Objects.isNull(this.loadDataInformation)) {
            throw new IllegalStateException("The loadDataInformation should be informed");
        }
        return new LoadableURLResource(this.cache, this.loadDataInformation);
    }

    public String toString() {
        return LoadableURLResourceBuilder.class.getName() + '{' + " loadDataInformation: " + this.loadDataInformation + ',' + " cache: " + this.loadDataInformation + '}';
    }
}

