/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader.urlconnection;

import java.util.Map;
import java.util.Timer;
import org.javamoney.moneta.spi.loader.LoaderListener;
import org.javamoney.moneta.spi.loader.urlconnection.LoadableURLResource;
import org.javamoney.moneta.spi.loader.urlconnection.URLConnectionScheduler;
import org.javamoney.moneta.spi.loader.urlconnection.URLLoadDataService;
import org.javamoney.moneta.spi.loader.urlconnection.URLLoadLocalDataService;
import org.javamoney.moneta.spi.loader.urlconnection.URLLoadRemoteDataService;

class URLConnectionLoaderServiceFacade {
    private final URLConnectionScheduler scheduledDataLoaderService;
    private final URLLoadDataService loadDataLoaderService;
    private final URLLoadLocalDataService loadDataLocalLoaderService;
    private final URLLoadRemoteDataService loadRemoteDataLoaderService;

    URLConnectionLoaderServiceFacade(Timer timer, LoaderListener listener, Map<String, LoadableURLResource> resources) {
        this.scheduledDataLoaderService = new URLConnectionScheduler(timer, listener);
        this.loadDataLoaderService = new URLLoadDataService(listener);
        this.loadDataLocalLoaderService = new URLLoadLocalDataService(resources, listener);
        this.loadRemoteDataLoaderService = new URLLoadRemoteDataService(listener);
    }

    public void scheduledData(LoadableURLResource load) {
        this.scheduledDataLoaderService.execute(load);
    }

    public boolean loadData(String resourceId, Map<String, LoadableURLResource> resources) {
        return this.loadDataLoaderService.execute(resourceId, resources);
    }

    public boolean loadDataLocal(String resourceId) {
        return this.loadDataLocalLoaderService.execute(resourceId);
    }

    public boolean loadDataRemote(String resourceId, Map<String, LoadableURLResource> resources) {
        return this.loadRemoteDataLoaderService.execute(resourceId, resources);
    }

    public String toString() {
        return URLConnectionLoaderServiceFacade.class.getName() + '{' + " scheduledDataLoaderService: " + this.scheduledDataLoaderService + ',' + " asyncLoaderService: " + this.loadDataLoaderService + ',' + " loadDataLocalLoaderService: " + this.loadDataLocalLoaderService + ',';
    }
}

