/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader.urlconnection;

import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.spi.loader.LoaderListener;
import org.javamoney.moneta.spi.loader.urlconnection.LoadableURLResource;

class URLLoadDataService {
    private static final Logger LOG = Logger.getLogger(URLLoadDataService.class.getName());
    private final LoaderListener listener;

    URLLoadDataService(LoaderListener listener) {
        this.listener = listener;
    }

    public boolean execute(String resourceId, Map<String, LoadableURLResource> resources) {
        LoadableURLResource load = resources.get(resourceId);
        if (Objects.nonNull(load)) {
            try {
                if (load.load()) {
                    LOG.log(Level.FINE, "Read data from: " + load.getRemoteResources());
                    this.listener.trigger(resourceId, load);
                    LOG.log(Level.FINE, "New data successfully loaded from: " + load.getRemoteResources());
                    return true;
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to read/load resource (checking fallback): " + resourceId, e);
            }
            try {
                if (load.loadFallback()) {
                    LOG.log(Level.WARNING, "Read fallback data from: " + load.getFallbackResource());
                    this.listener.trigger(resourceId, load);
                    LOG.log(Level.WARNING, "Loaded fallback data from: " + load.getFallbackResource());
                    return true;
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to read/load fallback resource: " + resourceId, e);
            }
        } else {
            throw new IllegalArgumentException("No such resource: " + resourceId);
        }
        return false;
    }

    public String toString() {
        return URLLoadDataService.class.getName() + '{' + " listener: " + this.listener + '}';
    }
}

