/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi.loader.urlconnection;

import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.spi.loader.LoaderListener;
import org.javamoney.moneta.spi.loader.urlconnection.LoadableURLResource;

class URLLoadRemoteDataService {
    private static final Logger LOG = Logger.getLogger(URLLoadRemoteDataService.class.getName());
    private final LoaderListener listener;

    URLLoadRemoteDataService(LoaderListener listener) {
        this.listener = listener;
    }

    public boolean execute(String resourceId, Map<String, LoadableURLResource> resources) {
        LoadableURLResource load = resources.get(resourceId);
        if (Objects.nonNull(load)) {
            try {
                load.readCache();
                this.listener.trigger(resourceId, load);
                load.loadRemote();
                this.listener.trigger(resourceId, load);
                LOG.config("The exchange rate with resourceId " + resourceId + " was started remotely");
                return true;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to load resource: " + resourceId, e);
            }
        } else {
            throw new IllegalArgumentException("No such resource: " + resourceId);
        }
        return false;
    }

    public String toString() {
        return URLLoadRemoteDataService.class.getName() + '{' + " listener: " + this.listener + '}';
    }
}

