/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.com.fasterxml.classmate.util;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.com.fasterxml.classmate.ResolvedType;

public class ResolvedTypeCache
implements Serializable {
    protected final CacheMap _map;

    public ResolvedTypeCache(int maxEntries) {
        this._map = new CacheMap(maxEntries);
    }

    public Key key(Class<?> simpleType) {
        return new Key(simpleType);
    }

    public Key key(Class<?> simpleType, ResolvedType[] tp) {
        return new Key(simpleType, tp);
    }

    public synchronized ResolvedType find(Key key) {
        return (ResolvedType)this._map.get(key);
    }

    public synchronized int size() {
        return this._map.size();
    }

    public synchronized void put(Key key, ResolvedType type) {
        this._map.put(key, type);
    }

    public void add(ResolvedType type) {
        List<ResolvedType> tp = type.getTypeParameters();
        ResolvedType[] tpa = tp.toArray(new ResolvedType[tp.size()]);
        this.put(this.key(type.getErasedType(), tpa), type);
    }

    private static final class CacheMap
    extends LinkedHashMap<Key, ResolvedType> {
        protected final int _maxEntries;

        public CacheMap(int maxEntries) {
            this._maxEntries = maxEntries;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Key, ResolvedType> eldest) {
            return this.size() > this._maxEntries;
        }
    }

    public static class Key {
        private final Class<?> _erasedType;
        private final ResolvedType[] _typeParameters;
        private final int _hashCode;

        public Key(Class<?> simpleType) {
            this(simpleType, null);
        }

        public Key(Class<?> erasedType, ResolvedType[] tp) {
            if (tp != null && tp.length == 0) {
                tp = null;
            }
            this._erasedType = erasedType;
            this._typeParameters = tp;
            int h = erasedType.getName().hashCode();
            if (tp != null) {
                h += tp.length;
            }
            this._hashCode = h;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Key other = (Key)o;
            if (other._erasedType != this._erasedType) {
                return false;
            }
            ResolvedType[] otherTP = other._typeParameters;
            if (this._typeParameters == null) {
                return otherTP == null;
            }
            if (otherTP == null || otherTP.length != this._typeParameters.length) {
                return false;
            }
            int len = this._typeParameters.length;
            for (int i = 0; i < len; ++i) {
                if (this._typeParameters[i].equals(otherTP[i])) continue;
                return false;
            }
            return true;
        }
    }
}

