/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.skife.jdbi.v2.BuiltInArgumentFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class Foreman {
    private final List<ArgumentFactory> factories = new CopyOnWriteArrayList<ArgumentFactory>();
    private static final ArgumentFactory BUILT_INS = new BuiltInArgumentFactory();

    Foreman() {
        this.factories.add(BUILT_INS);
    }

    Foreman(List<ArgumentFactory> factories) {
        this.factories.addAll(factories);
    }

    public Argument createArgument(Class<?> expectedType, Object boundValue, StatementContext ctx) {
        ArgumentFactory candidate = null;
        for (int i = this.factories.size() - 1; i >= 0; --i) {
            ArgumentFactory factory = this.factories.get(i);
            if (factory.accepts(expectedType, boundValue, ctx)) {
                return factory.build(expectedType, boundValue, ctx);
            }
            if (candidate != null || !factory.accepts(Object.class, boundValue, ctx)) continue;
            candidate = factory;
        }
        if (candidate != null) {
            return candidate.build(Object.class, boundValue, ctx);
        }
        throw new IllegalStateException("Unbindable argument passed: " + String.valueOf(boundValue));
    }

    void register(ArgumentFactory<?> argumentFactory) {
        this.factories.add(argumentFactory);
    }

    Foreman createChild() {
        return new Foreman(this.factories);
    }
}

