/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.lang.reflect.Type;
import java.util.List;
import org.skife.jdbi.com.fasterxml.classmate.ResolvedType;
import org.skife.jdbi.com.fasterxml.classmate.TypeResolver;
import org.skife.jdbi.v2.ResultColumnMapperFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

class InferredColumnMapperFactory
implements ResultColumnMapperFactory {
    private static final TypeResolver tr = new TypeResolver();
    private final Class<?> maps;
    private final ResultColumnMapper mapper;

    InferredColumnMapperFactory(ResultColumnMapper mapper) {
        this.mapper = mapper;
        ResolvedType rt = tr.resolve(mapper.getClass(), new Type[0]);
        List<ResolvedType> rs = rt.typeParametersFor(ResultColumnMapper.class);
        if (rs.isEmpty() || rs.get(0).getErasedType().equals(Object.class)) {
            throw new UnsupportedOperationException("Must use a concretely typed ResultColumnMapper here");
        }
        this.maps = rs.get(0).getErasedType();
    }

    @Override
    public boolean accepts(Class type, StatementContext ctx) {
        return this.maps.equals(type);
    }

    @Override
    public ResultColumnMapper columnMapperFor(Class type, StatementContext ctx) {
        return this.mapper;
    }
}

