/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.Cleanables;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.ContainerFactoryRegistry;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.GeneratedKeys;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.QueryResultMunger;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.tweak.RewrittenStatement;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementBuilder;
import org.skife.jdbi.v2.tweak.StatementCustomizer;
import org.skife.jdbi.v2.tweak.StatementLocator;
import org.skife.jdbi.v2.tweak.StatementRewriter;
import org.skife.jdbi.v2.util.SingleColumnMapper;

public class PreparedBatch
extends SQLStatement<PreparedBatch> {
    private final List<PreparedBatchPart> parts = new ArrayList<PreparedBatchPart>();
    private Binding currentBinding = new Binding();

    PreparedBatch(StatementLocator locator, StatementRewriter rewriter, Handle handle, StatementBuilder statementBuilder, String sql, ConcreteStatementContext ctx, SQLLog log, TimingCollector timingCollector, Collection<StatementCustomizer> statementCustomizers, Foreman foreman, ContainerFactoryRegistry containerFactoryRegistry) {
        super(new Binding(), locator, rewriter, handle, statementBuilder, sql, ctx, log, timingCollector, statementCustomizers, foreman, containerFactoryRegistry);
    }

    @Override
    public PreparedBatch define(String key, Object value) {
        this.getContext().setAttribute(key, value);
        return this;
    }

    @Override
    public PreparedBatch define(Map<String, ? extends Object> values) {
        if (values != null) {
            for (Map.Entry<String, ? extends Object> entry : values.entrySet()) {
                this.getContext().setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public int[] execute() {
        return (int[])this.internalBatchExecute(null, null);
    }

    public <GeneratedKeyType> GeneratedKeys<GeneratedKeyType> executeAndGenerateKeys(final ResultSetMapper<GeneratedKeyType> mapper) {
        return (GeneratedKeys)this.internalBatchExecute(new QueryResultMunger<GeneratedKeys<GeneratedKeyType>>(){

            @Override
            public GeneratedKeys<GeneratedKeyType> munge(Statement results) throws SQLException {
                return new GeneratedKeys(mapper, PreparedBatch.this, results, PreparedBatch.this.getContext(), PreparedBatch.this.getContainerMapperRegistry());
            }
        }, null);
    }

    public <GeneratedKeyType> GeneratedKeys<GeneratedKeyType> executeAndGenerateKeys(final ResultSetMapper<GeneratedKeyType> mapper, String ... columnNames) {
        return (GeneratedKeys)this.internalBatchExecute(new QueryResultMunger<GeneratedKeys<GeneratedKeyType>>(){

            @Override
            public GeneratedKeys<GeneratedKeyType> munge(Statement results) throws SQLException {
                return new GeneratedKeys(mapper, PreparedBatch.this, results, PreparedBatch.this.getContext(), PreparedBatch.this.getContainerMapperRegistry());
            }
        }, columnNames);
    }

    public <GeneratedKeyType> GeneratedKeys<GeneratedKeyType> executeAndGenerateKeys(ResultColumnMapper<GeneratedKeyType> mapper) {
        return this.executeAndGenerateKeys(new SingleColumnMapper<GeneratedKeyType>(mapper));
    }

    public <GeneratedKeyType> GeneratedKeys<GeneratedKeyType> executeAndGenerateKeys(ResultColumnMapper<GeneratedKeyType> mapper, String ... columnNames) {
        return this.executeAndGenerateKeys(new SingleColumnMapper<GeneratedKeyType>(mapper), columnNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Result> Object internalBatchExecute(QueryResultMunger<Result> munger, String[] columnNames) {
        String my_sql;
        boolean generateKeys;
        boolean bl = generateKeys = munger != null;
        if (this.parts.size() == 0) {
            if (generateKeys) {
                throw new IllegalArgumentException("Unable generate keys for a not prepared batch");
            }
            return new int[0];
        }
        PreparedBatchPart current = this.parts.get(0);
        try {
            my_sql = this.getStatementLocator().locate(this.getSql(), this.getContext());
        }
        catch (Exception e) {
            throw new UnableToCreateStatementException(String.format("Exception while locating statement for [%s]", this.getSql()), e, this.getContext());
        }
        RewrittenStatement rewritten = this.getRewriter().rewrite(my_sql, current.getParams(), this.getContext());
        PreparedStatement stmt = null;
        try {
            try {
                Connection connection = this.getHandle().getConnection();
                stmt = generateKeys ? (columnNames != null ? connection.prepareStatement(rewritten.getSql(), columnNames) : connection.prepareStatement(rewritten.getSql(), 1)) : connection.prepareStatement(rewritten.getSql(), 2);
                this.addCleanable(Cleanables.forStatement(stmt));
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException(e, this.getContext());
            }
            try {
                for (PreparedBatchPart part : this.parts) {
                    rewritten.bind(part.getParams(), stmt);
                    stmt.addBatch();
                }
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Exception while binding parameters", e, this.getContext());
            }
            this.beforeExecution(stmt);
            try {
                long start = System.nanoTime();
                int[] rs = stmt.executeBatch();
                long elapsedTime = System.nanoTime() - start;
                this.getLog().logPreparedBatch(elapsedTime / 1000000L, rewritten.getSql(), this.parts.size());
                this.getTimingCollector().collect(elapsedTime, this.getContext());
                this.afterExecution(stmt);
                int[] nArray = generateKeys ? (Object)munger.munge(stmt) : rs;
                return nArray;
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException(e, this.getContext());
            }
        }
        finally {
            try {
                if (!generateKeys) {
                    this.cleanup();
                }
            }
            finally {
                this.parts.clear();
            }
        }
    }

    public PreparedBatchPart add() {
        PreparedBatchPart part = new PreparedBatchPart(this.currentBinding, this, this.getStatementLocator(), this.getRewriter(), this.getHandle(), this.getStatementBuilder(), this.getSql(), this.getConcreteContext(), this.getLog(), this.getTimingCollector(), this.getForeman(), this.getContainerMapperRegistry());
        this.parts.add(part);
        this.currentBinding = new Binding();
        return part;
    }

    public PreparedBatch add(Object ... args) {
        PreparedBatchPart part = this.add();
        for (int i = 0; i < args.length; ++i) {
            part.bind(i, args[i]);
        }
        return this;
    }

    public PreparedBatchPart add(Map<String, ? extends Object> args) {
        PreparedBatchPart part = this.add();
        part.bindFromMap(args);
        return part;
    }

    public int getSize() {
        return this.parts.size();
    }

    public int size() {
        return this.parts.size();
    }

    @Override
    protected Binding getParams() {
        return this.currentBinding;
    }
}

