/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public enum ByteColumnMapper implements ResultColumnMapper<Byte>
{
    PRIMITIVE(false),
    WRAPPER(true);

    private final boolean nullable;

    private ByteColumnMapper(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public Byte mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        byte value = r.getByte(columnNumber);
        return this.nullable && r.wasNull() ? null : Byte.valueOf(value);
    }

    @Override
    public Byte mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        byte value = r.getByte(columnLabel);
        return this.nullable && r.wasNull() ? null : Byte.valueOf(value);
    }
}

