/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public enum DoubleColumnMapper implements ResultColumnMapper<Double>
{
    PRIMITIVE(false),
    WRAPPER(true);

    private final boolean nullable;

    private DoubleColumnMapper(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public Double mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        double value = r.getDouble(columnNumber);
        return this.nullable && r.wasNull() ? null : Double.valueOf(value);
    }

    @Override
    public Double mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        double value = r.getDouble(columnLabel);
        return this.nullable && r.wasNull() ? null : Double.valueOf(value);
    }
}

