/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.commons.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.PreconditionViolationException;
import org.junit.gen5.commons.util.StringUtils;

@API(value=API.Usage.Internal)
public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T notNull(T object, String message) throws PreconditionViolationException {
        return Preconditions.notNull(object, () -> message);
    }

    public static Object[] notNull(Object[] objects, String message) throws PreconditionViolationException {
        Preconditions.notNull(objects, () -> "objects array must not be null");
        Arrays.stream(objects).forEach(object -> Preconditions.notNull(object, () -> message));
        return objects;
    }

    public static <T> T notNull(T object, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(object != null, messageSupplier);
        return object;
    }

    public static String notEmpty(String str, String message) throws PreconditionViolationException {
        return Preconditions.notEmpty(str, () -> message);
    }

    public static String notEmpty(String str, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(StringUtils.isNotEmpty(str), messageSupplier);
        return str;
    }

    public static <T extends Collection<?>> T notEmpty(T collection, String message) throws PreconditionViolationException {
        Preconditions.condition(collection != null && !collection.isEmpty(), () -> message);
        return collection;
    }

    public static String notBlank(String str, String message) throws PreconditionViolationException {
        return Preconditions.notBlank(str, () -> message);
    }

    public static String notBlank(String str, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(StringUtils.isNotBlank(str), messageSupplier);
        return str;
    }

    public static void condition(boolean predicate, String message) throws PreconditionViolationException {
        Preconditions.condition(predicate, () -> message);
    }

    public static void condition(boolean predicate, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (!predicate) {
            throw new PreconditionViolationException(messageSupplier.get());
        }
    }
}

