/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.commons.util;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.junit.gen5.commons.meta.API;

@API(value=API.Usage.Internal)
public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return !StringUtils.isEmpty(charSequence);
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String nullSafeToString(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            return "";
        }
        return Arrays.stream(classes).map(Class::getName).collect(Collectors.joining(", "));
    }
}

