/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.discovery;

import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.PreconditionViolationException;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.engine.DiscoverySelector;

@API(value=API.Usage.Experimental)
public class ClassSelector
implements DiscoverySelector {
    private final Class<?> testClass;

    public static ClassSelector forClass(Class<?> testClass) {
        return new ClassSelector(testClass);
    }

    public static ClassSelector forClassName(String className) {
        return ClassSelector.forClass((Class)ReflectionUtils.loadClass((String)className).orElseThrow(() -> new PreconditionViolationException("Could not resolve class with name: " + className)));
    }

    private ClassSelector(Class<?> testClass) {
        this.testClass = testClass;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }
}

