/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.gen5.api.DisplayName;
import org.junit.gen5.api.Executable;
import org.junit.gen5.api.Tag;
import org.junit.gen5.api.extension.ExtendWith;
import org.junit.gen5.api.extension.Extension;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.AnnotationUtils;
import org.junit.gen5.commons.util.ExceptionUtils;
import org.junit.gen5.commons.util.StringUtils;
import org.junit.gen5.engine.TestTag;
import org.junit.gen5.engine.junit5.extension.ExtensionRegistry;
import org.junit.gen5.engine.support.descriptor.AbstractTestDescriptor;

@API(value=API.Usage.Internal)
public abstract class JUnit5TestDescriptor
extends AbstractTestDescriptor {
    protected JUnit5TestDescriptor(String uniqueId) {
        super(uniqueId);
    }

    protected Set<TestTag> getTags(AnnotatedElement element) {
        return AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)element, Tag.class).stream().map(Tag::value).filter(StringUtils::isNotBlank).map(TestTag::new).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected String determineDisplayName(AnnotatedElement element, String defaultName) {
        return AnnotationUtils.findAnnotation((AnnotatedElement)element, DisplayName.class).map(DisplayName::value).filter(StringUtils::isNotBlank).orElse(defaultName);
    }

    protected ExtensionRegistry populateNewExtensionRegistryFromExtendWith(AnnotatedElement annotatedElement, ExtensionRegistry existingExtensionRegistry) {
        List<Class<? extends Extension>> extensionTypes = AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)annotatedElement, ExtendWith.class).stream().map(ExtendWith::value).flatMap(Arrays::stream).collect(Collectors.toList());
        return ExtensionRegistry.newRegistryFrom(existingExtensionRegistry, extensionTypes);
    }

    protected void executeAndMaskThrowable(Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable throwable) {
            ExceptionUtils.throwAsUncheckedException((Throwable)throwable);
        }
    }
}

