/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.execution;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.junit.gen5.api.extension.ExtensionContext;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.Preconditions;

@API(value=API.Usage.Internal)
public class ExtensionValuesStore {
    private final ExtensionValuesStore parentStore;
    private final Map<Object, StoredValue> storedValues = new HashMap<Object, StoredValue>();

    ExtensionValuesStore() {
        this(null);
    }

    public ExtensionValuesStore(ExtensionValuesStore parentStore) {
        this.parentStore = parentStore;
    }

    Object get(ExtensionContext.Namespace namespace, Object key) {
        StoredValue storedValue = this.getStoredValue(namespace, key);
        if (storedValue != null) {
            return storedValue.value;
        }
        if (this.parentStore != null) {
            return this.parentStore.get(namespace, key);
        }
        return null;
    }

    private StoredValue getStoredValue(ExtensionContext.Namespace namespace, Object key) {
        ComposedKey composedKey = new ComposedKey(namespace, key);
        return this.storedValues.get(composedKey);
    }

    void put(ExtensionContext.Namespace namespace, Object key, Object value) {
        Preconditions.notNull((Object)namespace, (String)"Namespace must not be null");
        Preconditions.notNull((Object)key, (String)"key must not be null");
        this.putStoredValue(namespace, key, new StoredValue(value));
    }

    private void putStoredValue(ExtensionContext.Namespace namespace, Object key, StoredValue storedValue) {
        ComposedKey composedKey = new ComposedKey(namespace, key);
        this.storedValues.put(composedKey, storedValue);
    }

    Object getOrComputeIfAbsent(ExtensionContext.Namespace namespace, Object key, Function<Object, Object> defaultCreator) {
        StoredValue storedValue = this.getStoredValue(namespace, key);
        if (storedValue == null) {
            storedValue = new StoredValue(defaultCreator.apply(key));
            this.putStoredValue(namespace, key, storedValue);
        }
        return storedValue.value;
    }

    Object remove(ExtensionContext.Namespace namespace, Object key) {
        ComposedKey composedKey = new ComposedKey(namespace, key);
        StoredValue previous = this.storedValues.remove(composedKey);
        return previous != null ? previous.value : null;
    }

    private static class StoredValue {
        private final Object value;

        private StoredValue(Object value) {
            this.value = value;
        }
    }

    private static class ComposedKey {
        private final Object key;
        private final ExtensionContext.Namespace namespace;

        private ComposedKey(ExtensionContext.Namespace namespace, Object key) {
            this.key = key;
            this.namespace = namespace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComposedKey composedKey = (ComposedKey)o;
            return this.namespace.equals((Object)composedKey.namespace) && this.key.equals(composedKey.key);
        }

        public int hashCode() {
            return 31 * this.key.hashCode() + this.namespace.hashCode();
        }
    }
}

